/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.StandardNumberProperty;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LongNumberProperty
extends StandardNumberProperty
implements PropertyVariant {
    @Nullable
    private final Long nullValue;
    public static final JsonpDeserializer<LongNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LongNumberProperty::setupLongNumberPropertyDeserializer);

    private LongNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static LongNumberProperty of(Function<Builder, ObjectBuilder<LongNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Long;
    }

    @Nullable
    public final Long nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "long");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.longValue());
        }
    }

    protected static void setupLongNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        StandardNumberProperty.setupStandardNumberPropertyDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.longDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends StandardNumberProperty.AbstractBuilder<Builder>
    implements ObjectBuilder<LongNumberProperty> {
        @Nullable
        private Long nullValue;

        public final Builder nullValue(@Nullable Long value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LongNumberProperty build() {
            this._checkSingleUse();
            return new LongNumberProperty(this);
        }
    }
}

