/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.SlackAttachment;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SlackDynamicAttachment
implements JsonpSerializable {
    private final SlackAttachment attachmentTemplate;
    private final String listPath;
    public static final JsonpDeserializer<SlackDynamicAttachment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlackDynamicAttachment::setupSlackDynamicAttachmentDeserializer);

    private SlackDynamicAttachment(Builder builder) {
        this.attachmentTemplate = ApiTypeHelper.requireNonNull(builder.attachmentTemplate, this, "attachmentTemplate");
        this.listPath = ApiTypeHelper.requireNonNull(builder.listPath, this, "listPath");
    }

    public static SlackDynamicAttachment of(Function<Builder, ObjectBuilder<SlackDynamicAttachment>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final SlackAttachment attachmentTemplate() {
        return this.attachmentTemplate;
    }

    public final String listPath() {
        return this.listPath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attachment_template");
        this.attachmentTemplate.serialize(generator, mapper);
        generator.writeKey("list_path");
        generator.write(this.listPath);
    }

    protected static void setupSlackDynamicAttachmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attachmentTemplate, SlackAttachment._DESERIALIZER, "attachment_template");
        op.add(Builder::listPath, JsonpDeserializer.stringDeserializer(), "list_path");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlackDynamicAttachment> {
        private SlackAttachment attachmentTemplate;
        private String listPath;

        public final Builder attachmentTemplate(SlackAttachment value) {
            this.attachmentTemplate = value;
            return this;
        }

        public final Builder attachmentTemplate(Function<SlackAttachment.Builder, ObjectBuilder<SlackAttachment>> fn) {
            return this.attachmentTemplate(fn.apply(new SlackAttachment.Builder()).build());
        }

        public final Builder listPath(String value) {
            this.listPath = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlackDynamicAttachment build() {
            this._checkSingleUse();
            return new SlackDynamicAttachment(this);
        }
    }
}

