/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.TriggerEvent;
import co.elastic.clients.elasticsearch.watcher.TriggerEventVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScheduleTriggerEvent
implements TriggerEventVariant,
JsonpSerializable {
    private final String scheduledTime;
    @Nullable
    private final String triggeredTime;
    public static final JsonpDeserializer<ScheduleTriggerEvent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScheduleTriggerEvent::setupScheduleTriggerEventDeserializer);

    private ScheduleTriggerEvent(Builder builder) {
        this.scheduledTime = ApiTypeHelper.requireNonNull(builder.scheduledTime, this, "scheduledTime");
        this.triggeredTime = builder.triggeredTime;
    }

    public static ScheduleTriggerEvent of(Function<Builder, ObjectBuilder<ScheduleTriggerEvent>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TriggerEvent.Kind _triggerEventKind() {
        return TriggerEvent.Kind.Schedule;
    }

    public final String scheduledTime() {
        return this.scheduledTime;
    }

    @Nullable
    public final String triggeredTime() {
        return this.triggeredTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("scheduled_time");
        generator.write(this.scheduledTime);
        if (this.triggeredTime != null) {
            generator.writeKey("triggered_time");
            generator.write(this.triggeredTime);
        }
    }

    protected static void setupScheduleTriggerEventDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::scheduledTime, JsonpDeserializer.stringDeserializer(), "scheduled_time");
        op.add(Builder::triggeredTime, JsonpDeserializer.stringDeserializer(), "triggered_time");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ScheduleTriggerEvent> {
        private String scheduledTime;
        @Nullable
        private String triggeredTime;

        public final Builder scheduledTime(String value) {
            this.scheduledTime = value;
            return this;
        }

        public final Builder triggeredTime(@Nullable String value) {
            this.triggeredTime = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScheduleTriggerEvent build() {
            this._checkSingleUse();
            return new ScheduleTriggerEvent(this);
        }
    }
}

