/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.dispatch;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.common.concurrent.AsyncDelayedExecutor;
import cn.ponfee.scheduler.common.concurrent.DelayedData;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.enums.Operations;
import cn.ponfee.scheduler.core.enums.RouteStrategy;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.core.model.SchedTrack;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.DispatchParam;
import cn.ponfee.scheduler.registry.Discovery;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class TaskDispatcher
implements AutoCloseable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Discovery<Worker> discoveryWorker;
    private final TimingWheel<ExecuteParam> timingWheel;
    private final int maxRetryTimes;
    private final AsyncDelayedExecutor<DispatchParam> asyncDelayedExecutor;

    public TaskDispatcher(Discovery<Worker> discoveryWorker, @Nullable TimingWheel<ExecuteParam> timingWheel) {
        this(discoveryWorker, timingWheel, 5);
    }

    public TaskDispatcher(Discovery<Worker> discoveryWorker, @Nullable TimingWheel<ExecuteParam> timingWheel, int maxRetryTimes) {
        this.discoveryWorker = discoveryWorker;
        this.timingWheel = timingWheel;
        this.maxRetryTimes = maxRetryTimes;
        this.asyncDelayedExecutor = new AsyncDelayedExecutor(this::doDispatch);
    }

    protected abstract boolean dispatch(ExecuteParam var1) throws Exception;

    public final boolean dispatch(List<ExecuteParam> executeParams) {
        List<DispatchParam> list = executeParams.stream().peek(e -> Assert.notNull((Object)e.getWorker(), (String)"Dispatching execute param worker cannot be null.")).peek(e -> Assert.isTrue((e.operation() != Operations.TRIGGER ? 1 : 0) != 0, (String)"Dispatching execute param operation cannot be TRIGGER.")).map(e -> new DispatchParam((ExecuteParam)e, null, null)).collect(Collectors.toList());
        return this.doDispatch(list);
    }

    public final boolean dispatch(SchedJob job, SchedTrack track, List<SchedTask> tasks) {
        ArrayList<DispatchParam> dispatchParams = new ArrayList<DispatchParam>(tasks.size());
        for (SchedTask task : tasks) {
            ExecuteParam executeParam = new ExecuteParam(Operations.TRIGGER, task.getTaskId().longValue(), track.getTrackId().longValue(), job.getJobId().longValue(), track.getTriggerTime().longValue());
            DispatchParam dispatchParam = new DispatchParam(executeParam, job.getJobGroup(), RouteStrategy.of((Integer)job.getRouteStrategy()));
            dispatchParams.add(dispatchParam);
        }
        return this.doDispatch(dispatchParams);
    }

    @Override
    public void close() {
    }

    private boolean doDispatch(DispatchParam dispatchParam) {
        return this.doDispatch(Collections.singletonList(dispatchParam));
    }

    private boolean doDispatch(List<DispatchParam> dispatchParams) {
        Worker current = Worker.current();
        boolean result = true;
        for (DispatchParam dispatchParam : dispatchParams) {
            this.assignWorker(dispatchParam);
            ExecuteParam executeParam = dispatchParam.executeParam();
            if (executeParam.getWorker() == null) {
                this.retry(dispatchParam);
                result = false;
                continue;
            }
            try {
                boolean status = this.timingWheel != null && executeParam.getWorker().equals((Object)current) ? this.timingWheel.offer((TimingWheel.Timing)executeParam) : this.dispatch(executeParam);
                if (status) continue;
                this.retry(dispatchParam);
                this.log.error("Dispatch task failed: " + (Object)((Object)dispatchParam));
                result = false;
            }
            catch (Exception e) {
                this.retry(dispatchParam);
                this.log.error("Dispatch task error: " + (Object)((Object)dispatchParam), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    private void assignWorker(DispatchParam dispatchParam) {
        ExecuteParam executeParam = dispatchParam.executeParam();
        if (executeParam.operation() != Operations.TRIGGER) {
            return;
        }
        List workers = this.discoveryWorker.getDiscoveredServers(dispatchParam.group());
        Worker worker = dispatchParam.routeStrategy().route(executeParam, workers);
        executeParam.setWorker(worker);
    }

    private void retry(DispatchParam dispatchParam) {
        if (dispatchParam.retried() >= this.maxRetryTimes) {
            this.log.warn("Dispatched task retried max times still failed: " + dispatchParam.executeParam());
            return;
        }
        dispatchParam.retrying();
        this.asyncDelayedExecutor.put(new DelayedData((Object)dispatchParam, (long)(1000 * IntMath.pow((int)dispatchParam.retried(), (int)2))));
    }
}

