/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.RootFinder;

public class WeibullDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;
    private double delta;

    public WeibullDist(double alpha) {
        this.setParams(alpha, 1.0, 0.0);
    }

    public WeibullDist(double alpha, double lambda, double delta) {
        this.setParams(alpha, lambda, delta);
    }

    @Override
    public double density(double x) {
        return WeibullDist.density(this.alpha, this.lambda, this.delta, x);
    }

    @Override
    public double cdf(double x) {
        return WeibullDist.cdf(this.alpha, this.lambda, this.delta, x);
    }

    @Override
    public double barF(double x) {
        return WeibullDist.barF(this.alpha, this.lambda, this.delta, x);
    }

    @Override
    public double inverseF(double u) {
        return WeibullDist.inverseF(this.alpha, this.lambda, this.delta, u);
    }

    @Override
    public double getMean() {
        return WeibullDist.getMean(this.alpha, this.lambda, this.delta);
    }

    @Override
    public double getVariance() {
        return WeibullDist.getVariance(this.alpha, this.lambda, this.delta);
    }

    @Override
    public double getStandardDeviation() {
        return WeibullDist.getStandardDeviation(this.alpha, this.lambda, this.delta);
    }

    public static double density(double alpha, double lambda, double delta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= delta) {
            return 0.0;
        }
        double y = Math.log(lambda * (x - delta)) * alpha;
        if (y >= 7.0) {
            return 0.0;
        }
        y = Math.exp(y);
        return alpha * (y / (x - delta)) * Math.exp(-y);
    }

    public static double density(double alpha, double x) {
        return WeibullDist.density(alpha, 1.0, 0.0, x);
    }

    public static double cdf(double alpha, double lambda, double delta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= delta) {
            return 0.0;
        }
        if (lambda * (x - delta) >= 100.0 && alpha >= 1.0) {
            return 1.0;
        }
        double y = Math.log(lambda * (x - delta)) * alpha;
        if (y >= 3.65) {
            return 1.0;
        }
        y = Math.exp(y);
        return -Math.expm1(-y);
    }

    public static double cdf(double alpha, double x) {
        return WeibullDist.cdf(alpha, 1.0, 0.0, x);
    }

    public static double barF(double alpha, double lambda, double delta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= delta) {
            return 1.0;
        }
        if (alpha >= 1.0 && x >= 2048.0) {
            return 0.0;
        }
        double temp = Math.log(lambda * (x - delta)) * alpha;
        if (temp >= 709.782712893384) {
            return 0.0;
        }
        temp = Math.exp(temp);
        return Math.exp(-temp);
    }

    public static double barF(double alpha, double x) {
        return WeibullDist.barF(alpha, 1.0, 0.0, x);
    }

    public static double inverseF(double alpha, double lambda, double delta, double u) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double t = -Math.log1p(-u);
        if (Math.log(t) / Math.log(10.0) >= alpha * 308.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        return Math.pow(t, 1.0 / alpha) / lambda + delta;
    }

    public static double inverseF(double alpha, double x) {
        return WeibullDist.inverseF(alpha, 1.0, 0.0, x);
    }

    private static double[] getMaximumLikelihoodEstimate(double[] x, int n, double delta) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (delta != 0.0) {
            throw new IllegalArgumentException("delta must be equal to 0");
        }
        double LN_EPS = -709.089565712824;
        double sumLn = 0.0;
        double sumLn2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double lnxi = x[i] <= delta ? -709.089565712824 : Math.log(x[i]);
            sumLn += lnxi;
            sumLn2 += lnxi * lnxi;
        }
        double alpha0 = Math.sqrt((double)n / (0.6079271018540267 * (sumLn2 - sumLn * sumLn / (double)n)));
        double a = alpha0 - 20.0;
        if (a <= delta) {
            a = delta + 1.0E-5;
        }
        double[] param = new double[3];
        param[2] = 0.0;
        Function f = new Function(x, n);
        param[0] = RootFinder.brentDekker(a, alpha0 + 20.0, f, 1.0E-5);
        double sumXalpha = 0.0;
        for (int i = 0; i < n; ++i) {
            sumXalpha += Math.pow(x[i], param[0]);
        }
        param[1] = Math.pow((double)n / sumXalpha, 1.0 / param[0]);
        return param;
    }

    public static double[] getMLE(double[] x, int n) {
        return WeibullDist.getMaximumLikelihoodEstimate(x, n, 0.0);
    }

    public static WeibullDist getInstanceFromMLE(double[] x, int n) {
        double[] param = WeibullDist.getMLE(x, n);
        return new WeibullDist(param[0], param[1], param[2]);
    }

    public static double getMean(double alpha, double lambda, double delta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return delta + Math.exp(Num.lnGamma(1.0 + 1.0 / alpha)) / lambda;
    }

    public static double getVariance(double alpha, double lambda, double delta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        double gAlpha = Math.exp(Num.lnGamma(1.0 / alpha + 1.0));
        return Math.abs(Math.exp(Num.lnGamma(2.0 / alpha + 1.0)) - gAlpha * gAlpha) / (lambda * lambda);
    }

    public static double getStandardDeviation(double alpha, double lambda, double delta) {
        return Math.sqrt(WeibullDist.getVariance(alpha, lambda, delta));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double alpha, double lambda, double delta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = alpha;
        this.lambda = lambda;
        this.delta = delta;
        this.supportA = delta;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.lambda, this.delta};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : alpha = " + this.alpha + ", lambda = " + this.lambda + ", delta = " + this.delta;
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double[] xi;
        private double[] lnXi;
        private double sumLnXi = 0.0;
        private final double LN_EPS = -709.089565712824;

        public Function(double[] x, int n) {
            this.n = n;
            this.xi = new double[n];
            this.lnXi = new double[n];
            for (int i = 0; i < n; ++i) {
                this.xi[i] = x[i];
                this.lnXi[i] = x[i] > 0.0 ? Math.log(x[i]) : -709.089565712824;
                this.sumLnXi += this.lnXi[i];
            }
        }

        @Override
        public double evaluate(double x) {
            if (x <= 0.0) {
                return 1.0E200;
            }
            double sumXiLnXi = 0.0;
            double sumXi = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double xalpha = Math.pow(this.xi[i], x);
                sumXiLnXi += xalpha * this.lnXi[i];
                sumXi += xalpha;
            }
            return x * ((double)this.n * sumXiLnXi - this.sumLnXi * sumXi) - (double)this.n * sumXi;
        }
    }
}

