/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.anova.Integrator;
import umontreal.ssj.mcqmctools.anova.RandomIntegrator;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.util.Chrono;

public class MeanVarExperiment {
    protected String name;
    protected MonteCarloModelDouble model;
    protected RandomIntegrator integrator;
    protected double cpuSeconds;
    protected double average;
    protected double variance;
    protected int nObservations;
    protected String statReport;

    public MeanVarExperiment(String name, MonteCarloModelDouble model, RandomIntegrator integrator) {
        this.name = name;
        this.model = model;
        this.integrator = integrator;
        this.cpuSeconds = 0.0;
        this.average = 0.0;
        this.variance = 0.0;
        this.nObservations = 0;
    }

    public MeanVarExperiment(MonteCarloModelDouble model, RandomIntegrator integrator) {
        this(null, model, integrator);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MonteCarloModelDouble getModel() {
        return this.model;
    }

    public void setModel(MonteCarloModelDouble model) {
        this.model = model;
    }

    public Integrator getIntegrator() {
        return this.integrator;
    }

    public void setIntegrator(RandomIntegrator integrator) {
        this.integrator = integrator;
    }

    public double getCPUSeconds() {
        return this.cpuSeconds;
    }

    public double getSecondsPerSimulation() {
        return this.cpuSeconds / (double)this.integrator.getTotalSimulations();
    }

    public double getAverage() {
        return this.average;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getScaledVariance() {
        return this.variance * (double)this.integrator.getTotalSimulations() / (double)this.nObservations;
    }

    public void simulate() {
        this.simulate(new Tally(this.model.getClass().getSimpleName()));
    }

    public void simulate(Tally stat) {
        Chrono timer = new Chrono();
        stat.init();
        this.integrator.integrate(this.model, stat);
        this.cpuSeconds = timer.getSeconds();
        this.average = stat.average();
        this.variance = stat.variance();
        this.nObservations = stat.numberObs();
        stat.setConfidenceIntervalStudent();
        this.statReport = stat.report(0.95, 4);
    }

    public String report() {
        return this.statReport + String.format("Variance:     %9.4g\n", this.getVariance()) + String.format("Scaled Var.:  %9.4g\n", this.getScaledVariance()) + String.format("CPU time:     %9s\n", Chrono.format(this.cpuSeconds));
    }

    public String toString() {
        return "MeanVarExperiment" + (this.name == null ? "" : " " + this.name) + ":\n  Model: " + this.model + "\n  Integrator: " + this.integrator;
    }
}

