/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools;

import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.hups.RQMCPointSet;
import umontreal.ssj.mcqmctools.MonteCarloExperiment;
import umontreal.ssj.mcqmctools.MonteCarloModelCV;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.MonteCarloModelDoubleArray;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.TallyStore;
import umontreal.ssj.stat.list.ListOfTallies;
import umontreal.ssj.stat.list.lincv.ListOfTalliesWithCV;
import umontreal.ssj.util.Chrono;
import umontreal.ssj.util.PrintfFormat;

public class RQMCExperiment
extends MonteCarloExperiment {
    public static void simulReplicatesRQMC(MonteCarloModelDouble model, RQMCPointSet prqmc, int m, Tally statReps) {
        RQMCExperiment.simulReplicatesRQMC(model, prqmc.getPointSet(), prqmc.getRandomization(), m, statReps);
    }

    public static void simulReplicatesRQMC(MonteCarloModelDouble model, PointSet p, PointSetRandomization rand, int m, Tally statReps) {
        statReps.init();
        int n = p.getNumPoints();
        Tally statValue = new Tally();
        PointSetIterator stream = p.iterator();
        for (int rep = 0; rep < m; ++rep) {
            rand.randomize(p);
            stream.resetStartStream();
            RQMCExperiment.simulateRuns(model, n, (RandomStream)stream, statValue);
            statReps.add(statValue.average());
        }
    }

    public static void simulReplicatesRQMC(MonteCarloModelDouble model, RQMCPointSet prqmc, int m, Tally statReps, double[][] data) {
        RQMCExperiment.simulReplicatesRQMC(model, prqmc.getPointSet(), prqmc.getRandomization(), m, statReps, data);
    }

    public static void simulReplicatesRQMC(MonteCarloModelDouble model, PointSet p, PointSetRandomization rand, int m, Tally statReps, double[][] data) {
        int n = p.getNumPoints();
        data = new double[m][];
        TallyStore statSave = new TallyStore(n);
        PointSetIterator stream = p.iterator();
        for (int rep = 0; rep < m; ++rep) {
            rand.randomize(p);
            stream.resetStartStream();
            RQMCExperiment.simulateRuns(model, n, (RandomStream)stream, statSave);
            statReps.add(statSave.average());
            statSave.quickSort();
            data[rep] = statSave.getArray();
            statSave = new TallyStore(n);
        }
    }

    public static String simulReplicatesRQMCDefaultReport(MonteCarloModelDouble model, PointSet p, PointSetRandomization rand, int m, RandomStream noise, Tally statRQMC) {
        PrintfFormat str = new PrintfFormat();
        Chrono timer = new Chrono();
        RQMCExperiment.simulReplicatesRQMC(model, p, rand, m, statRQMC);
        statRQMC.setConfidenceIntervalStudent();
        str.append(model.toString());
        str.append(p.toString());
        str.append(rand.toString());
        str.append(statRQMC.report(0.95, 4));
        str.append("Total CPU time:      " + timer.format() + "\n");
        return str.toString();
    }

    public static String simulReplicatesRQMCDefaultReportCompare(MonteCarloModelDouble model, PointSet p, PointSetRandomization rand, int m, Tally statRQMC, double varianceMC, double secondsMC) {
        PrintfFormat str = new PrintfFormat();
        Chrono timer = new Chrono();
        RQMCExperiment.simulReplicatesRQMC(model, p, rand, m, statRQMC);
        double secondsRQMC = timer.getSeconds() / (double)(m * p.getNumPoints());
        double varianceRQMC = (double)p.getNumPoints() * statRQMC.variance();
        statRQMC.setConfidenceIntervalStudent();
        str.append(model.toString());
        str.append(p.toString());
        str.append(rand.toString());
        str.append(statRQMC.report(0.95, 4));
        str.append("Total CPU time:      " + timer.format() + "\n");
        str.append("Variance per run: ");
        str.append(12, 5, 4, varianceRQMC);
        str.append("Variance ratio:   ");
        str.append(12, 5, 4, varianceMC / varianceRQMC);
        str.append("Efficiency ratio: ");
        str.append(12, 5, 4, varianceMC * secondsMC / (varianceRQMC * secondsRQMC));
        str.append("-------------------------------------------\n");
        return str.toString();
    }

    public static void simulReplicatesRQMC(MonteCarloModelDoubleArray model, RQMCPointSet prqmc, int m, ListOfTallies<Tally> statRepsList) {
        RQMCExperiment.simulReplicatesRQMC(model, prqmc.getPointSet(), prqmc.getRandomization(), m, statRepsList);
    }

    public static void simulReplicatesRQMC(MonteCarloModelDoubleArray model, PointSet p, PointSetRandomization rand, int m, ListOfTallies<Tally> statRepsList) {
        statRepsList.init();
        int n = p.getNumPoints();
        int t = model.getPerformanceDim();
        ListOfTallies<Tally> statValue = ListOfTallies.createWithTally(t);
        PointSetIterator stream = p.iterator();
        for (int rep = 0; rep < m; ++rep) {
            rand.randomize(p);
            stream.resetStartStream();
            RQMCExperiment.simulateRuns(model, n, (RandomStream)stream, statValue);
            double[] means = new double[t];
            statValue.average(means);
            statRepsList.add(means);
        }
    }

    public static void simulReplicatesRQMC(MonteCarloModelDoubleArray model, RQMCPointSet prqmc, int m, ListOfTallies<Tally> statRepsList, double[][][] data) {
        RQMCExperiment.simulReplicatesRQMC(model, prqmc.getPointSet(), prqmc.getRandomization(), m, statRepsList, data);
    }

    public static void simulReplicatesRQMC(MonteCarloModelDoubleArray model, PointSet p, PointSetRandomization rand, int m, ListOfTallies<Tally> statRepsList, double[][][] data) {
        int n = p.getNumPoints();
        int t = model.getPerformanceDim();
        ListOfTallies<TallyStore> statSave = ListOfTallies.createWithTallyStore(n, t);
        PointSetIterator stream = p.iterator();
        for (int rep = 0; rep < m; ++rep) {
            p.randomize(rand);
            stream.resetStartStream();
            RQMCExperiment.simulateRuns(model, n, (RandomStream)stream, statSave);
            double[] means = new double[t];
            statSave.average(means);
            statRepsList.add(means);
            for (int i = 0; i < t; ++i) {
                for (int k = 0; k < n; ++k) {
                    data[rep][k][i] = ((TallyStore)statSave.get(i)).getArray()[k];
                }
            }
            statSave = ListOfTallies.createWithTallyStore(n, t);
        }
    }

    public static void simulReplicatesRQMCCV(MonteCarloModelCV model, RQMCPointSet prqmc, int m, ListOfTalliesWithCV<Tally> statWithCV) {
        RQMCExperiment.simulReplicatesRQMCCV(model, prqmc.getPointSet(), prqmc.getRandomization(), m, statWithCV);
    }

    public static void simulReplicatesRQMCCV(MonteCarloModelCV model, PointSet p, PointSetRandomization rand, int m, ListOfTalliesWithCV<Tally> statWithCV) {
        statWithCV.init();
        int n = p.getNumPoints();
        int numCV = model.getNumberCV();
        PointSetIterator stream = p.iterator();
        for (int rep = 0; rep < m; ++rep) {
            rand.randomize(p);
            stream.resetStartStream();
            double sumValues = 0.0;
            double[] sumValuesCV = new double[numCV];
            double[] curValuesCV = new double[numCV];
            for (int i = 0; i < n; ++i) {
                model.simulate(stream);
                sumValues += model.getPerformance();
                curValuesCV = model.getValuesCV();
                for (int k = 0; k < numCV; ++k) {
                    int n2 = k;
                    sumValuesCV[n2] = sumValuesCV[n2] + curValuesCV[k];
                }
                stream.resetNextSubstream();
            }
            int k = 0;
            while (k < numCV) {
                int n3 = k++;
                sumValuesCV[n3] = sumValuesCV[n3] / (double)n;
            }
            statWithCV.add(sumValues / (double)n, sumValuesCV);
        }
    }

    public static void simulFDReplicatesRQMC(MonteCarloModelDouble model1, MonteCarloModelDouble model2, double delta, PointSet p, PointSetRandomization rand, int m, Tally statDiffRQMC) {
        Tally statValue = new Tally("stat on value");
        statDiffRQMC.init();
        PointSetIterator stream = p.iterator();
        for (int j = 0; j < m; ++j) {
            rand.randomize(p);
            stream.resetStartStream();
            RQMCExperiment.simulateRuns(model1, p.getNumPoints(), (RandomStream)stream, statValue);
            double average1 = statValue.average();
            stream.resetStartStream();
            RQMCExperiment.simulateRuns(model2, p.getNumPoints(), (RandomStream)stream, statValue);
            statDiffRQMC.add((statValue.average() - average1) / delta);
        }
    }
}

