/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_EIP;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.model.v23.datatype.TQ;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ORC
extends AbstractSegment {
    public ORC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(119)}, "Order Control");
            this.add(EI.class, false, 0, 22, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Placer Group Number");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(38)}, "Order Status");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(121)}, "Response Flag");
            this.add(TQ.class, true, 1, 200, new Object[]{this.getMessage()}, "Quantity/Timing");
            this.add(CM_EIP.class, false, 1, 200, new Object[]{this.getMessage()}, "Parent Order");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time of Transaction");
            this.add(XCN.class, false, 1, 120, new Object[]{this.getMessage()}, "Entered By");
            this.add(XCN.class, false, 1, 120, new Object[]{this.getMessage()}, "Verified By");
            this.add(XCN.class, false, 0, 120, new Object[]{this.getMessage()}, "Ordering Provider");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Enterer's Location");
            this.add(XTN.class, false, 2, 40, new Object[]{this.getMessage()}, "Call Back Phone Number");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Order Effective Date/Time");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Order Control Code Reason");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Entering Organization");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Entering Device");
            this.add(XCN.class, false, 1, 120, new Object[]{this.getMessage()}, "Action By");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getOrderControl() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getOrc1_OrderControl() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public EI[] getPlacerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(2, (Type[])new EI[0]);
        return retVal;
    }

    public EI[] getOrc2_PlacerOrderNumber() {
        EI[] retVal = (EI[])this.getTypedField(2, (Type[])new EI[0]);
        return retVal;
    }

    public int getPlacerOrderNumberReps() {
        return this.getReps(2);
    }

    public EI getPlacerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(2, rep);
        return retVal;
    }

    public EI getOrc2_PlacerOrderNumber(int rep) {
        EI retVal = (EI)this.getTypedField(2, rep);
        return retVal;
    }

    public int getOrc2_PlacerOrderNumberReps() {
        return this.getReps(2);
    }

    public EI insertPlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(2, rep);
    }

    public EI insertOrc2_PlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(2, rep);
    }

    public EI removePlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(2, rep);
    }

    public EI removeOrc2_PlacerOrderNumber(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(2, rep);
    }

    public EI getFillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getOrc3_FillerOrderNumber() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getPlacerGroupNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getOrc4_PlacerGroupNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getOrderStatus() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getOrc5_OrderStatus() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getResponseFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getOrc6_ResponseFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public TQ getQuantityTiming() {
        TQ retVal = (TQ)this.getTypedField(7, 0);
        return retVal;
    }

    public TQ getOrc7_QuantityTiming() {
        TQ retVal = (TQ)this.getTypedField(7, 0);
        return retVal;
    }

    public CM_EIP getParentOrder() {
        CM_EIP retVal = (CM_EIP)this.getTypedField(8, 0);
        return retVal;
    }

    public CM_EIP getOrc8_ParentOrder() {
        CM_EIP retVal = (CM_EIP)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getDateTimeOfTransaction() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getOrc9_DateTimeOfTransaction() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public XCN getEnteredBy() {
        XCN retVal = (XCN)this.getTypedField(10, 0);
        return retVal;
    }

    public XCN getOrc10_EnteredBy() {
        XCN retVal = (XCN)this.getTypedField(10, 0);
        return retVal;
    }

    public XCN getVerifiedBy() {
        XCN retVal = (XCN)this.getTypedField(11, 0);
        return retVal;
    }

    public XCN getOrc11_VerifiedBy() {
        XCN retVal = (XCN)this.getTypedField(11, 0);
        return retVal;
    }

    public XCN[] getOrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(12, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getOrc12_OrderingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(12, (Type[])new XCN[0]);
        return retVal;
    }

    public int getOrderingProviderReps() {
        return this.getReps(12);
    }

    public XCN getOrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(12, rep);
        return retVal;
    }

    public XCN getOrc12_OrderingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getOrc12_OrderingProviderReps() {
        return this.getReps(12);
    }

    public XCN insertOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(12, rep);
    }

    public XCN insertOrc12_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(12, rep);
    }

    public XCN removeOrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(12, rep);
    }

    public XCN removeOrc12_OrderingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(12, rep);
    }

    public PL getEntererSLocation() {
        PL retVal = (PL)this.getTypedField(13, 0);
        return retVal;
    }

    public PL getOrc13_EntererSLocation() {
        PL retVal = (PL)this.getTypedField(13, 0);
        return retVal;
    }

    public XTN[] getCallBackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(14, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getOrc14_CallBackPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(14, (Type[])new XTN[0]);
        return retVal;
    }

    public int getCallBackPhoneNumberReps() {
        return this.getReps(14);
    }

    public XTN getCallBackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(14, rep);
        return retVal;
    }

    public XTN getOrc14_CallBackPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getOrc14_CallBackPhoneNumberReps() {
        return this.getReps(14);
    }

    public XTN insertCallBackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN insertOrc14_CallBackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN removeCallBackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public XTN removeOrc14_CallBackPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public TS getOrderEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public TS getOrc15_OrderEffectiveDateTime() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getOrderControlCodeReason() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getOrc16_OrderControlCodeReason() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getEnteringOrganization() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getOrc17_EnteringOrganization() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getEnteringDevice() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getOrc18_EnteringDevice() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public XCN getActionBy() {
        XCN retVal = (XCN)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN getOrc19_ActionBy() {
        XCN retVal = (XCN)this.getTypedField(19, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(119));
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(38));
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(121));
            }
            case 6: {
                return new TQ(this.getMessage());
            }
            case 7: {
                return new CM_EIP(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new XCN(this.getMessage());
            }
            case 11: {
                return new XCN(this.getMessage());
            }
            case 12: {
                return new PL(this.getMessage());
            }
            case 13: {
                return new XTN(this.getMessage());
            }
            case 14: {
                return new TS(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

