/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.metrics;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import java.io.Serializable;
import java.net.SocketAddress;

public class CommandLatencyId
implements Serializable,
Comparable<CommandLatencyId> {
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final ProtocolKeyword commandType;

    protected CommandLatencyId(SocketAddress localAddress, SocketAddress remoteAddress, ProtocolKeyword commandType) {
        Preconditions.checkArgument((localAddress != null ? 1 : 0) != 0, (Object)"localAddress must not be null");
        Preconditions.checkArgument((remoteAddress != null ? 1 : 0) != 0, (Object)"remoteAddress must not be null");
        Preconditions.checkArgument((commandType != null ? 1 : 0) != 0, (Object)"commandType must not be null");
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.commandType = commandType;
    }

    public static CommandLatencyId create(SocketAddress localAddress, SocketAddress remoteAddress, ProtocolKeyword commandType) {
        return new CommandLatencyId(localAddress, remoteAddress, commandType);
    }

    public SocketAddress localAddress() {
        return this.localAddress;
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public ProtocolKeyword commandType() {
        return this.commandType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandLatencyId)) {
            return false;
        }
        CommandLatencyId that = (CommandLatencyId)o;
        if (!this.localAddress.equals(that.localAddress)) {
            return false;
        }
        if (!this.remoteAddress.equals(that.remoteAddress)) {
            return false;
        }
        return this.commandType.equals(that.commandType);
    }

    public int hashCode() {
        int result = this.localAddress.hashCode();
        result = 31 * result + this.remoteAddress.hashCode();
        result = 31 * result + this.commandType.hashCode();
        return result;
    }

    @Override
    public int compareTo(CommandLatencyId o) {
        if (o == null) {
            return -1;
        }
        int remoteResult = this.remoteAddress.toString().compareTo(o.remoteAddress.toString());
        if (remoteResult != 0) {
            return remoteResult;
        }
        int localResult = this.localAddress.toString().compareTo(o.localAddress.toString());
        if (localResult != 0) {
            return localResult;
        }
        return this.commandType.toString().compareTo(o.commandType.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.localAddress);
        sb.append(" -> ").append(this.remoteAddress);
        sb.append(", commandType=").append(this.commandType);
        sb.append(']');
        return sb.toString();
    }
}

