/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.slots;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ClusterSlotRange
implements Serializable {
    private int from;
    private int to;
    @Deprecated
    private HostAndPort master;
    private RedisClusterNode masterNode;
    @Deprecated
    private List<HostAndPort> slaves = Collections.emptyList();
    private List<RedisClusterNode> slaveNodes = Collections.emptyList();

    public ClusterSlotRange() {
    }

    @Deprecated
    public ClusterSlotRange(int from, int to, HostAndPort master, List<HostAndPort> slaves) {
        Preconditions.checkArgument((master != null ? 1 : 0) != 0, (Object)"master must not be null");
        Preconditions.checkArgument((slaves != null ? 1 : 0) != 0, (Object)"slaves must not be null");
        this.from = from;
        this.to = to;
        this.masterNode = this.toRedisClusterNode(master, null, Collections.singleton(RedisClusterNode.NodeFlag.MASTER));
        this.slaveNodes = this.toRedisClusterNodes(slaves, null, Collections.singleton(RedisClusterNode.NodeFlag.SLAVE));
        this.master = master;
        this.slaves = slaves;
    }

    public ClusterSlotRange(int from, int to, RedisClusterNode masterNode, List<RedisClusterNode> slaveNodes) {
        Preconditions.checkArgument((masterNode != null ? 1 : 0) != 0, (Object)"masterNode must not be null");
        Preconditions.checkArgument((slaveNodes != null ? 1 : 0) != 0, (Object)"slaveNodes must not be null");
        this.from = from;
        this.to = to;
        this.master = this.toHostAndPort(masterNode);
        this.slaves = this.toHostAndPorts(slaveNodes);
        this.masterNode = masterNode;
        this.slaveNodes = slaveNodes;
    }

    private HostAndPort toHostAndPort(RedisClusterNode redisClusterNode) {
        RedisURI uri = redisClusterNode.getUri();
        return HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort());
    }

    private List<HostAndPort> toHostAndPorts(List<RedisClusterNode> nodes) {
        ArrayList result = Lists.newArrayList();
        for (RedisClusterNode node : nodes) {
            result.add(this.toHostAndPort(node));
        }
        return result;
    }

    private RedisClusterNode toRedisClusterNode(HostAndPort hostAndPort, String slaveOf, Set<RedisClusterNode.NodeFlag> flags) {
        RedisClusterNode redisClusterNode = new RedisClusterNode();
        new RedisURI.Builder();
        redisClusterNode.setUri(RedisURI.Builder.redis(hostAndPort.getHostText(), hostAndPort.getPortOrDefault(6379)).build());
        redisClusterNode.setSlaveOf(slaveOf);
        redisClusterNode.setFlags(flags);
        return redisClusterNode;
    }

    private List<RedisClusterNode> toRedisClusterNodes(List<HostAndPort> hostAndPorts, String slaveOf, Set<RedisClusterNode.NodeFlag> flags) {
        ArrayList result = Lists.newArrayList();
        for (HostAndPort hostAndPort : hostAndPorts) {
            result.add(this.toRedisClusterNode(hostAndPort, slaveOf, flags));
        }
        return result;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    @Deprecated
    public HostAndPort getMaster() {
        return this.master;
    }

    @Deprecated
    public List<HostAndPort> getSlaves() {
        return this.slaves;
    }

    public RedisClusterNode getMasterNode() {
        return this.masterNode;
    }

    public void setMasterNode(RedisClusterNode masterNode) {
        this.masterNode = masterNode;
    }

    public List<RedisClusterNode> getSlaveNodes() {
        return this.slaveNodes;
    }

    public void setSlaveNodes(List<RedisClusterNode> slaveNodes) {
        this.slaveNodes = slaveNodes;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setTo(int to) {
        this.to = to;
    }

    public void setMaster(HostAndPort master) {
        Preconditions.checkArgument((master != null ? 1 : 0) != 0, (Object)"master must not be null");
        this.master = master;
    }

    public void setSlaves(List<HostAndPort> slaves) {
        Preconditions.checkArgument((slaves != null ? 1 : 0) != 0, (Object)"slaves must not be null");
        this.slaves = slaves;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [from=").append(this.from);
        sb.append(", to=").append(this.to);
        sb.append(", masterNode=").append(this.masterNode);
        sb.append(", slaveNodes=").append(this.slaveNodes);
        sb.append(']');
        return sb.toString();
    }
}

