/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.BaseRedisCommandBuilder;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.IntegerOutput;
import com.lambdaworks.redis.output.ListOfMapsOutput;
import com.lambdaworks.redis.output.MapOutput;
import com.lambdaworks.redis.output.StatusOutput;
import com.lambdaworks.redis.output.ValueListOutput;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import java.util.List;
import java.util.Map;

class SentinelCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    public SentinelCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    public Command<K, V, List<V>> getMasterAddrByKey(K key) {
        CommandArgs args = new CommandArgs(this.codec).add("get-master-addr-by-name").addKey(key);
        return this.createCommand(CommandType.SENTINEL, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<Map<K, V>>> masters() {
        CommandArgs args = new CommandArgs(this.codec).add("masters");
        return this.createCommand(CommandType.SENTINEL, new ListOfMapsOutput(this.codec), args);
    }

    public Command<K, V, Map<K, V>> master(K key) {
        CommandArgs args = new CommandArgs(this.codec).add("master").addKey(key);
        return this.createCommand(CommandType.SENTINEL, new MapOutput(this.codec), args);
    }

    public Command<K, V, List<Map<K, V>>> slaves(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SLAVES).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new ListOfMapsOutput(this.codec), args);
    }

    public Command<K, V, Long> reset(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESET).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> failover(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FAILOVER).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> monitor(K key, String ip, int port, int quorum) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.MONITOR).addKey(key).add(ip).add(port).add(quorum);
        return this.createCommand(CommandType.SENTINEL, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> set(K key, String option, V value) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.SET).addKey(key).add(option).addValue(value);
        return this.createCommand(CommandType.SENTINEL, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> ping() {
        return this.createCommand(CommandType.PING, new StatusOutput(this.codec));
    }

    public Command<K, V, String> remove(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REMOVE).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new StatusOutput(this.codec), args);
    }
}

