/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MigrateArgs<K> {
    private boolean copy = false;
    private boolean replace = false;
    List<K> keys = new ArrayList<K>();

    public MigrateArgs<K> copy() {
        this.copy = true;
        return this;
    }

    public MigrateArgs<K> replace() {
        this.replace = true;
        return this;
    }

    public MigrateArgs<K> key(K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key must not be null");
        this.keys.add(key);
        return this;
    }

    public MigrateArgs<K> keys(K ... keys) {
        Preconditions.checkArgument((keys != null && keys.length != 0 ? 1 : 0) != 0, (Object)"keys must not be empty");
        for (K key : keys) {
            this.keys.add(key);
        }
        return this;
    }

    public MigrateArgs<K> keys(Iterable<K> keys) {
        Preconditions.checkArgument((keys != null ? 1 : 0) != 0, (Object)"keys must not be null");
        Iterator<K> iterator = keys.iterator();
        while (iterator.hasNext()) {
            this.keys.add(iterator.next());
        }
        return this;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.copy) {
            args.add(CommandKeyword.COPY);
        }
        if (this.replace) {
            args.add(CommandKeyword.REPLACE);
        }
        if (this.keys.size() > 1) {
            args.add(CommandType.KEYS);
            for (K key : this.keys) {
                args.addKey(key);
            }
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K> MigrateArgs<K> copy() {
            return new MigrateArgs().copy();
        }

        public static <K> MigrateArgs<K> replace() {
            return new MigrateArgs().replace();
        }

        public static <K> MigrateArgs<K> key(K key) {
            return new MigrateArgs<K>().key(key);
        }

        public static <K> MigrateArgs<K> keys(K ... keys) {
            return new MigrateArgs<K>().keys(keys);
        }

        public static <K> MigrateArgs<K> keys(Iterable<K> keys) {
            return new MigrateArgs<K>().keys(keys);
        }
    }
}

