/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;
import org.alfresco.jlan.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

public class PerfFilesPerFolderTest
extends Test {
    private static final int DefaultNumberOfFiles = 2000;
    private static final long DefaultFileSize = 4096L;
    private static final int DefaultWriteSize = 4096;
    private static final int MinimumNumberOfFiles = 50;
    private static final int MaximumNumberOfFiles = 5000;
    private static final long MinimumFileSize = 1L;
    private static final long MaximumFileSize = 0xA00000L;
    private static final int MinimumWriteSize = 128;
    private static final int MaximumWriteSize = 65536;
    private static String[] _namePrefixes = new String[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh", "iii", "jjj", "kkk", "lll", "mmm", "nnn", "ooo", "ppp", "qqq", "rrr", "sss", "ttt", "uuu", "vvv", "www", "xxx", "yyy", "zzz", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF", "GGG", "HHH", "III", "JJJ", "KKK", "LLL", "MMM", "NNN", "OOO", "PPP", "QQQ", "RRR", "SSS", "TTT", "UUU", "VVV", "WWW", "XXX", "YYY", "ZZZ"};
    private static String _testFileName = "_FilesPerFolder_";
    private static String _testFileExt = ".txt";
    private int m_filesPerFolder = 2000;
    private long m_fileSize = 4096L;
    private int m_writeSize = 4096;
    private String m_testFolder;
    private ArrayList<String> m_fnameList;

    public PerfFilesPerFolderTest() {
        super("PerfFilesPerFolder");
    }

    @Override
    public void configTest(ConfigElement config) throws InvalidConfigurationException {
        String valueStr = config.getAttribute("fileCount");
        if (valueStr != null) {
            try {
                this.m_filesPerFolder = Integer.parseInt(valueStr);
                if (this.m_filesPerFolder < 50 || this.m_filesPerFolder > 5000) {
                    throw new InvalidConfigurationException("Invalid files per folder (50 - 5000)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid files per folder, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("fileSize")) != null) {
            try {
                this.m_fileSize = MemorySize.getByteValue(valueStr);
                if (this.m_fileSize < 1L || this.m_fileSize > 0xA00000L) {
                    throw new InvalidConfigurationException("Invalid file size (1 - 10485760)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid file size, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("writeSize")) != null) {
            try {
                this.m_writeSize = MemorySize.getByteValueInt(valueStr);
                if (this.m_writeSize < 128 || this.m_writeSize > 65536) {
                    throw new InvalidConfigurationException("Invalid write buffer size (128 - 65536)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid write buffer size, " + valueStr);
            }
        }
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        if (threadId > 1) {
            return new BooleanTestResult(true);
        }
        TestResult result = null;
        try {
            this.m_testFolder = this.getPerTestFolderName(threadId, iteration);
            this.testLog(log, "Files Per Folder Performance Test");
            sess.CreateDirectory(this.m_testFolder);
            if (!sess.FileExists(this.m_testFolder)) {
                this.testLog(log, "Folder " + this.m_testFolder + " does not exist");
                result = new BooleanTestResult(true, "Folder does not exist, " + this.m_testFolder);
            } else {
                String testFolderPrefix = this.m_testFolder;
                if (!testFolderPrefix.startsWith("\\")) {
                    testFolderPrefix = "\\" + testFolderPrefix;
                }
                if (!testFolderPrefix.endsWith("\\")) {
                    testFolderPrefix = testFolderPrefix + "\\";
                }
                this.m_fnameList = new ArrayList(this.m_filesPerFolder);
                byte[] ioBuf = new byte[this.m_writeSize];
                long startTime = System.currentTimeMillis();
                long endTime = 0L;
                int fileCnt = 1;
                Random randNum = new Random();
                StringBuilder testFileStr = new StringBuilder(64);
                String testFileName = null;
                while (fileCnt <= this.m_filesPerFolder && result == null) {
                    testFileStr.setLength(0);
                    testFileStr.append(testFolderPrefix);
                    testFileStr.append(_namePrefixes[fileCnt % _namePrefixes.length]);
                    testFileStr.append(_testFileName);
                    testFileStr.append(fileCnt);
                    testFileStr.append("_");
                    testFileStr.append(Long.toHexString(randNum.nextLong()));
                    testFileStr.append(_testFileExt);
                    testFileName = testFileStr.toString();
                    this.m_fnameList.add(testFileName);
                    byte testPat = (byte)_namePrefixes[fileCnt % _namePrefixes.length].charAt(0);
                    Arrays.fill(ioBuf, testPat);
                    try {
                        SMBFile testFile = sess.CreateFile(testFileName);
                        for (long fileSize = 0L; fileSize < this.m_fileSize; fileSize += (long)ioBuf.length) {
                            testFile.Write(ioBuf, ioBuf.length, 0);
                        }
                        testFile.Flush();
                        testFile.Close();
                        ++fileCnt;
                    }
                    catch (SMBException ex) {
                        result = new ExceptionTestResult(ex);
                    }
                }
                endTime = System.currentTimeMillis();
                if (result == null) {
                    long elapsedMs = endTime - startTime;
                    int ms = (int)(elapsedMs % 1000L);
                    long elapsedSecs = elapsedMs / 1000L;
                    int secs = (int)(elapsedSecs % 60L);
                    int mins = (int)(elapsedSecs / 60L % 60L);
                    int hrs = (int)(elapsedSecs / 3600L);
                    this.testLog(log, "Created " + this.m_filesPerFolder + " files (size " + MemorySize.asScaledString(this.m_fileSize) + ") in " + hrs + ":" + mins + ":" + secs + "." + ms + " (" + elapsedMs + "ms)");
                    result = new BooleanTestResult(true);
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            if (this.m_fnameList != null && this.m_fnameList.size() > 0) {
                for (int idx = 0; idx < this.m_fnameList.size(); ++idx) {
                    sess.DeleteFile(this.m_fnameList.get(idx));
                }
            }
            sess.DeleteDirectory(this.m_testFolder);
        }
    }
}

