/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermNumberList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class TermLongList
extends TermNumberList<Long> {
    private static Logger log = Logger.getLogger(TermLongList.class);
    protected long[] _elements = null;
    private long sanity = -1L;
    private boolean withDummy = true;

    protected long parse(String s) {
        if (s == null || s.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public TermLongList() {
    }

    public TermLongList(int capacity, String formatString) {
        super(capacity, formatString);
    }

    public TermLongList(String formatString) {
        super(formatString);
    }

    @Override
    public boolean add(String o) {
        long item;
        if (this._innerList.size() == 0 && o != null) {
            this.withDummy = false;
        }
        if (this.sanity >= (item = this.parse(o))) {
            throw new RuntimeException("Values need to be added in ascending order and we only support non-negative numbers. Previous value: " + this.sanity + " adding value: " + item);
        }
        if (this._innerList.size() > 0 || !this.withDummy) {
            this.sanity = item;
        }
        return ((LongArrayList)this._innerList).add(item);
    }

    @Override
    protected List<?> buildPrimitiveList(int capacity) {
        this._type = Long.class;
        return capacity > 0 ? new LongArrayList(capacity) : new LongArrayList();
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String get(int index) {
        DecimalFormat formatter = (DecimalFormat)this._formatter.get();
        if (formatter == null) {
            return String.valueOf(this._elements[index]);
        }
        return formatter.format(this._elements[index]);
    }

    public long getPrimitiveValue(int index) {
        if (index < this._elements.length) {
            return this._elements[index];
        }
        return -1L;
    }

    @Override
    public int indexOf(Object o) {
        if (this.withDummy) {
            if (o == null) {
                return -1;
            }
            long val = this.parse(String.valueOf(o));
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        long val = this.parse(String.valueOf(o));
        return Arrays.binarySearch(this._elements, val);
    }

    public int indexOf(Long value) {
        if (this.withDummy) {
            if (value == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, value);
        }
        return Arrays.binarySearch(this._elements, value);
    }

    public int indexOf(long val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(Long val) {
        if (this.withDummy) {
            if (val == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(long val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public void seal() {
        ((LongArrayList)this._innerList).trim();
        this._elements = ((LongArrayList)this._innerList).elements();
    }

    @Override
    protected Object parseString(String o) {
        return this.parse(o);
    }

    public boolean contains(long val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(Long val) {
        if (this.withDummy) {
            if (val == null) {
                return false;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(long val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }
}

