/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixTableModel;

public class MatrixTableModelLinear
extends AbstractTableModel
implements MatrixTableModel {
    private static final long serialVersionUID = -7498520067143762434L;
    private static Log log = LogFactory.getLog(MatrixTableModelLinear.class);
    protected MatrixND m = null;
    protected boolean showDefault = false;
    protected double defaultValue = 0.0;
    protected List<Object[]> mappingRowSems = new ArrayList<Object[]>();
    protected TableCellRenderer renderer = null;

    public MatrixTableModelLinear(MatrixND m, boolean showDefault) {
        this.showDefault = showDefault;
        this.setMatrix(m);
    }

    @Override
    public MatrixND getMatrix() {
        return this.m;
    }

    @Override
    public void setMatrix(MatrixND m) {
        this.m = m;
        this.computeMapping();
        this.fireTableStructureChanged();
    }

    protected void computeMapping() {
        this.mappingRowSems.clear();
        MatrixIterator i = this.m.iterator();
        while (i.next()) {
            Object[] sems = i.getSemanticsCoordinates();
            double value = i.getValue();
            if (!this.showDefault && value == this.defaultValue) continue;
            Object[] semsCopy = Arrays.copyOf(sems, sems.length);
            this.mappingRowSems.add(semsCopy);
        }
    }

    public boolean isShowDefault() {
        return this.showDefault;
    }

    public void setShowDefault(boolean showDefault) {
        this.showDefault = showDefault;
        this.computeMapping();
        this.fireTableDataChanged();
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
        this.computeMapping();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.mappingRowSems.size();
    }

    @Override
    public int getColumnCount() {
        return this.m.getDimCount() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        result = columnIndex < this.m.getDimCount() ? this.mappingRowSems.get(rowIndex)[columnIndex] : Double.valueOf(this.m.getValue(this.mappingRowSems.get(rowIndex)));
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == this.m.getDimCount();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            double val = Double.parseDouble((String)aValue);
            Object[] sems = this.mappingRowSems.get(rowIndex);
            this.m.setValue(sems, val);
            this.fireTableDataChanged();
        }
        catch (Exception eee) {
            log.debug((Object)("La nouvelle valeur n'est pas convertible en double: " + String.valueOf(aValue)), (Throwable)eee);
        }
    }

    @Override
    public String getColumnName(int column) {
        String result = null;
        if (column < this.m.getDimCount()) {
            String columnName = this.m.getDimensionName(column);
            result = I18n.t((String)columnName, (Object[])new Object[0]);
        } else {
            result = "";
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public TableCellRenderer getMatrixCellRenderer() {
        if (this.renderer == null) {
            this.renderer = new MatrixCellRenderer(this);
        }
        return this.renderer;
    }

    @Override
    public int getAdditionalRows() {
        return 0;
    }

    @Override
    public int getAdditionalColumns() {
        return this.m.getDimCount();
    }

    public static class MatrixCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 6537813058357761914L;
        protected MatrixTableModelLinear model = null;
        protected Color bg = null;
        protected Color fg = null;
        protected Font font = null;
        protected Border border = null;

        public MatrixCellRenderer(MatrixTableModelLinear model) {
            this.model = model;
            this.bg = this.getBackground();
            this.fg = this.getForeground();
            this.font = this.getFont();
            this.border = this.getBorder();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(this.getText());
            if (column < this.model.m.getDimCount()) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            } else {
                this.setBackground(this.bg);
                this.setForeground(this.fg);
                this.setFont(this.font);
                this.setBorder(this.border);
            }
            return this;
        }
    }
}

