package org.nuiton.jaxx.widgets.datetime;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class TimeEditor extends JPanel implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_TIME_EDITOR_SLIDER = "showTimeEditorSlider";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HOUR_EDITOR_ENABLED = "hourEditor.enabled";
    public static final String BINDING_HOUR_MODEL_VALUE = "hourModel.value";
    public static final String BINDING_MINUTE_EDITOR_ENABLED = "minuteEditor.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_SLIDER_ENABLED = "slider.enabled";
    public static final String BINDING_SLIDER_HIDOR_TARGET_VISIBLE = "sliderHidor.targetVisible";
    public static final String BINDING_SLIDER_VALUE = "slider.value";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1WTW8bRRieuLET2wkkTYlKmoJJEUpp2DiAKqHw0cRJ5FT5qGI3KuRQxt5JPGE8s52ZbdxaRfwEfgIfVy5I3DghDpw5cEH8BYQ4cEW8M7v27iaLnNSHlff9fp/3nWf2uz9RVkn02jHudBzpc03bxLm78uDBbuOYNPUaUU1JPS0kCn5DGZQ5QEW3L1ca3TjYMu6LoftiRbQ9wQmPeS9voYLSTxhRLUK0RteTHk2lFmt99XLH82Uvar+otKhf/f1X5kv3i68zCHU8qG4CWikN8oo6Gd5CGepqdBkyPcaLDPMjKENSfgT1jhtZhWGldnCbPEKfo5EtlPOwhGAazZ2/ZRvD+nc8jUZfv3sPc8LKGt0S8sjhPtWCO7boE+oeEa0cF2tiq6/DY90FA+l5NkROo2xbuIRpVL6A97ZxiULkW8IPZBrNmjY7jjqBrp2aRzkncg0inHIptin3Q6kRTUaqK6olTqJcNUZdIjWaNIEdg6mzKgQjmMcKeIzBCoM1oJCYV1/Rq8g893vCKELBdBkkhPnFewjgNWb5KJ+JvYUbpuGksRUaq5m+cW9CS+Z9Nqkr6H6ffW0p0hpce0VdSeQJkTWGc337HDPZq+bt1aRmLIA7yvRGUn9ZWZSr1BWyDuiu4jMZQ3GywmLMT6NXEtAHfla16mtYK+NzKypWhYOdSjZmpSHcEl1LhIRz7UTnOjp4QwcoK30Qa3T14CwV7IEqIIGrp0jABLTaf6enfvvxjx82eie/CLlfSjWNERecSE8KD5qgJvWLwbH3NWWL29hbPkB5RRiwnmW12ZTCaqEaioN8wYYbd6eKVQtCZEd+/+nn6U9/vYQyG6jABHY3sLHfhA1sSUBBMLfjfXTHVjR2Mmooy9QGoLaEpE8F15itMHrE25ZlbnQTp9M8K4IrjTmc88r6Tn1971kHYJpNgalfayP/yz9Tte/v9KAagtJf/l/zCK7sJyhHOaOcWJoMGTCVFoueIr4rIqZL4z4E3KWpZsQLj/F79vnBGTgyGo03MSPcxXKDEgYMPd2thAKnunt/7+HuxsO1lY+fQUQgDB9Wa6HbwtxlRDrAgdUeve0b5bwlTCM3JDV/8yZAZhKvWCzMvwqKc+I5yutxcLHb94JaRgjHDUag3PEuVevBy3x6uhhVnCPf82+HRsOadMB4zEya2IRONa2ikIyeYziT0XC2N3fu19djc3Hic9mO7pALTCZ+9VxgNuPdmN8Fp5Og30E5L0HEhpDAgvcw5dpkyB5ipqD7nPDwIwNDT5A/BFLQJnVPlpY+hd0HFTEMRWgsAcp9qqiNPwNt1lKuZugZ0Agubfggud7V83Ox5TAKJyhgzlq24G+qpVHELXNBAXCDdgNp+jhjzQ3qahTMPQOqvaaVWWZp4CxYYZ02P4tk+UM4H28p+hT+Z5aWNJpo42PAD4xqHm7C4QD57XLsA6rLyUlpjRxin+lV4XOXuHvwuRJszHx5obS0UILn7XLpzdLb75oOJ2AvTod8pxxt+0w3sdGbPNh4FUB+gQUML9tB+AzZY/tEwHWNXngfPolwqUG5C4V9eCbqkHkWBkY04m/M49v0CNcgwn/0wfrzNQwAAA==";
    private static final Log log = LogFactory.getLog(TimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel dateEditor;
    protected final TimeEditorHandler handler = createHandler();
    protected JSpinner hourEditor;
    protected SpinnerDateModel hourModel;
    protected JLabel labelH;
    protected JSpinner minuteEditor;
    protected SpinnerDateModel minuteModel;
    protected TimeEditorModel model;
    protected Boolean showTimeEditorSlider;
    protected JSlider slider;
    protected HidorButton sliderHidor;
    protected JToolBar sliderHidorToolBar;
    @ValidatorField( validatorId = "validator",  propertyName = "time",  editorName = "timeEditor")
    protected JPanel timeEditor;
    protected JLabel timeLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<TimeEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TimeEditor $JPanel0 = this;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setPropertyTime(String property) { model.setPropertyTime(property); }
    public void setTime(Date time) { model.setTime(time); }
    
    public void setLabel(String label) { timeLabel.setText(label); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditor() {
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doStateChanged__on__hourEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setHours((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__minuteEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setMinutes((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__slider(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!slider.getValueIsAdjusting()) model.setTimeInMinutes((Integer)((JSlider)event.getSource()).getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getDateEditor() {
        return dateEditor;
    }

    public TimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHourEditor() {
        return hourEditor;
    }

    public SpinnerDateModel getHourModel() {
        return hourModel;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JSpinner getMinuteEditor() {
        return minuteEditor;
    }

    public SpinnerDateModel getMinuteModel() {
        return minuteModel;
    }

    public TimeEditorModel getModel() {
        return model;
    }

    public Boolean getShowTimeEditorSlider() {
        return showTimeEditorSlider;
    }

    public JSlider getSlider() {
        return slider;
    }

    public HidorButton getSliderHidor() {
        return sliderHidor;
    }

    public JToolBar getSliderHidorToolBar() {
        return sliderHidorToolBar;
    }

    public JPanel getTimeEditor() {
        return timeEditor;
    }

    public JLabel getTimeLabel() {
        return timeLabel;
    }

    public SwingValidator<TimeEditorModel> getValidator() {
        return validator;
    }

    public Boolean isShowTimeEditorSlider() {
        return showTimeEditorSlider !=null && showTimeEditorSlider;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowTimeEditorSlider(Boolean showTimeEditorSlider) {
        Boolean oldValue = this.showTimeEditorSlider;
        this.showTimeEditorSlider = showTimeEditorSlider;
        firePropertyChange(PROPERTY_SHOW_TIME_EDITOR_SLIDER, oldValue, showTimeEditorSlider);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDateEditor() {
        if (!allComponentsCreated) {
            return;
        }
        dateEditor.add(timeLabel, BorderLayout.WEST);
        dateEditor.add($JPanel1, BorderLayout.EAST);
    }

    protected void addChildrenToSliderHidorToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        sliderHidorToolBar.add(sliderHidor);
    }

    protected void addChildrenToTimeEditor() {
        if (!allComponentsCreated) {
            return;
        }
        timeEditor.add(hourEditor);
        timeEditor.add(labelH);
        timeEditor.add(minuteEditor);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setBean(model);
    }

    protected void createDateEditor() {
        $objectMap.put("dateEditor", dateEditor = new JPanel());
        
        dateEditor.setName("dateEditor");
        dateEditor.setLayout(new BorderLayout());
    }

    protected TimeEditorHandler createHandler() {
        return new TimeEditorHandler();
    }

    protected void createHourEditor() {
        $objectMap.put("hourEditor", hourEditor = new JSpinner());
        
        hourEditor.setName("hourEditor");
        hourEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hourEditor"));
    }

    protected void createHourModel() {
        $objectMap.put("hourModel", hourModel = new SpinnerDateModel());
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setText(t("timeeditor.H"));
    }

    protected void createMinuteEditor() {
        $objectMap.put("minuteEditor", minuteEditor = new JSpinner());
        
        minuteEditor.setName("minuteEditor");
        minuteEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minuteEditor"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerDateModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = new TimeEditorModel());
    }

    protected void createShowTimeEditorSlider() {
        $objectMap.put("showTimeEditorSlider", showTimeEditorSlider = true);
    }

    protected void createSlider() {
        $objectMap.put("slider", slider = new JSlider());
        
        slider.setName("slider");
        slider.setValue(0);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        if (slider.getFont() != null) {
            slider.setFont(slider.getFont().deriveFont((float) 11));
        }
        slider.setMajorTickSpacing(60);
        slider.setMinorTickSpacing(30);
        slider.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__slider"));
    }

    protected void createSliderHidor() {
        $objectMap.put("sliderHidor", sliderHidor = new HidorButton());
        
        sliderHidor.setName("sliderHidor");
    }

    protected void createSliderHidorToolBar() {
        $objectMap.put("sliderHidorToolBar", sliderHidorToolBar = new JToolBar());
        
        sliderHidorToolBar.setName("sliderHidorToolBar");
        sliderHidorToolBar.setBorderPainted(false);
        sliderHidorToolBar.setOpaque(false);
        sliderHidorToolBar.setFloatable(false);
    }

    protected void createTimeEditor() {
        $objectMap.put("timeEditor", timeEditor = new JPanel());
        
        timeEditor.setName("timeEditor");
    }

    protected void createTimeLabel() {
        $objectMap.put("timeLabel", timeLabel = new JLabel());
        
        timeLabel.setName("timeLabel");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(TimeEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(dateEditor, BorderLayout.NORTH);
        add(slider, BorderLayout.SOUTH);
        addChildrenToValidator();
        addChildrenToDateEditor();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(timeEditor));
        $JPanel1.add(sliderHidorToolBar);
        addChildrenToTimeEditor();
        addChildrenToSliderHidorToolBar();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        hourModel.setCalendarField(Calendar.HOUR_OF_DAY);
        minuteModel.setCalendarField(Calendar.MINUTE);
        hourEditor.setModel(hourModel);
        labelH.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        minuteEditor.setModel(minuteModel);
        sliderHidor.setShowTip(t("timeeditor.show.slider"));
        sliderHidor.setHideTip(t("timeeditor.hide.slider"));
        sliderHidor.setTarget(slider);
        slider.setModel(new DefaultBoundedRangeModel(0, 1, 0, 60 * 24));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createHourModel();
        createMinuteModel();
        createShowTimeEditorSlider();
        createValidator();
        createDateEditor();
        createTimeLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createTimeEditor();
        createHourEditor();
        createLabelH();
        createMinuteEditor();
        createSliderHidorToolBar();
        createSliderHidor();
        createSlider();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourModel.setValue(handler.getHourModelValue(model.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteModel.setValue(handler.getMinuteModelValue(model.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hourEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minuteEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_HIDOR_TARGET_VISIBLE, true ,"showTimeEditorSlider") {
        
            @Override
            public void processDataBinding() {
                sliderHidor.setTargetVisible(isShowTimeEditorSlider());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SLIDER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeInMinutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    slider.setValue(model.getTimeInMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeInMinutes", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                slider.setEnabled(isEnabled());
            }
        });
    }

}