/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.chorem.pollen.votecounting.api.model.SimpleVoter;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.api.model.VoterBuilder;

public class SimpleVoterBuilder
implements VoterBuilder {
    private final Set<Voter> voters = Sets.newHashSet();
    private Voter voter;

    @Override
    public SimpleVoterBuilder newVoter(String voterId, double weight) {
        this.flush();
        this.voter = SimpleVoter.newVoter(voterId, weight, null);
        return this;
    }

    @Override
    public SimpleVoterBuilder addVoteForChoice(String choiceId, Double voteValue) {
        Preconditions.checkState((this.voter != null ? 1 : 0) != 0, (Object)"No voter defined, use method newVoter before this one");
        VoteForChoice voteForChoice = VoteForChoice.newVote(choiceId, voteValue);
        this.voter.addVoteForChoice(voteForChoice);
        return this;
    }

    @Override
    public Set<Voter> getVoters() {
        this.flush();
        return this.voters;
    }

    @Override
    public void flush() {
        if (this.voter != null) {
            this.voters.add(this.voter);
            this.voter = null;
        }
    }
}

