/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api;

import com.google.common.collect.Multimap;
import java.util.Locale;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.InvalidVoteCountingConfig;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.MinMaxChoicesNumberConfig;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.nuiton.i18n.I18n;

public abstract class AbstractVoteCountingMinMaxChoice
extends AbstractVoteCounting {
    protected AbstractVoteCountingMinMaxChoice(VoteCountings id) {
        super(id);
    }

    @Override
    public MinMaxChoicesNumberConfig createConfig() {
        return new MinMaxChoicesNumberConfig();
    }

    @Override
    public Multimap<String, String> validateVote(Voter vote, VoteCountingConfig config, Locale locale) {
        long nbChoice;
        Multimap<String, String> errorMap = super.validateVote(vote, config, locale);
        MinMaxChoicesNumberConfig minMaxConfig = InvalidVoteCountingConfig.castVoteCountingConfigOrFail(config, MinMaxChoicesNumberConfig.class);
        if (minMaxConfig.getMaxChoiceNumber() > 0 && (nbChoice = vote.getVoteForChoices().stream().filter(voteForChoice -> voteForChoice.getVoteValue() != null && voteForChoice.getVoteValue() != 0.0).count()) > (long)minMaxConfig.getMaxChoiceNumber()) {
            errorMap.put((Object)"choices", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.maxChoices.error.overflow", (Object[])new Object[0]));
        }
        if (minMaxConfig.getMinChoiceNumber() > 0 && (nbChoice = vote.getVoteForChoices().stream().filter(voteForChoice -> voteForChoice.getVoteValue() != null && voteForChoice.getVoteValue() != 0.0).count()) < (long)minMaxConfig.getMinChoiceNumber()) {
            errorMap.put((Object)"choices", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.minChoices.error.overflow", (Object[])new Object[0]));
        }
        return errorMap;
    }
}

