/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.config;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.chorem.pollen.persistence.UsersRight;
import org.chorem.pollen.persistence.entity.CommentVisibility;
import org.chorem.pollen.persistence.entity.PollType;
import org.chorem.pollen.persistence.entity.ResultVisibility;
import org.chorem.pollen.persistence.entity.VoteVisibility;
import org.chorem.pollen.services.config.PollenServicesConfigOption;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ConfigOptionDef;

public abstract class GeneratedPollenServicesConfig
implements Supplier<ApplicationConfig> {
    private ApplicationConfig applicationConfig;

    protected GeneratedPollenServicesConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedPollenServicesConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions((ConfigOptionDef[])PollenServicesConfigOption.values());
    }

    @Override
    public ApplicationConfig get() {
        return this.applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        this.applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public File getDataDirectory() {
        return this.applicationConfig.getOptionAsFile(PollenServicesConfigOption.DATA_DIRECTORY.getKey());
    }

    public void setDataDirectory(File dataDirectory) {
        this.setOption(PollenServicesConfigOption.DATA_DIRECTORY.getKey(), dataDirectory);
    }

    public String getTokenSecret() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.TOKEN_SECRET.getKey());
    }

    public void setTokenSecret(String tokenSecret) {
        this.setOption(PollenServicesConfigOption.TOKEN_SECRET.getKey(), tokenSecret);
    }

    public String getTokenIssue() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.TOKEN_ISSUE.getKey());
    }

    public void setTokenIssue(String tokenIssue) {
        this.setOption(PollenServicesConfigOption.TOKEN_ISSUE.getKey(), tokenIssue);
    }

    public int getTokenTimeout() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.TOKEN_TIMEOUT.getKey());
    }

    public void setTokenTimeout(int tokenTimeout) {
        this.setOption(PollenServicesConfigOption.TOKEN_TIMEOUT.getKey(), tokenTimeout);
    }

    public Boolean getTokenCookieSecure() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.TOKEN_COOKIE_SECURE.getKey());
    }

    public boolean isTokenCookieSecure() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.TOKEN_COOKIE_SECURE.getKey());
    }

    public void setTokenCookieSecure(Boolean tokenCookieSecure) {
        this.setOption(PollenServicesConfigOption.TOKEN_COOKIE_SECURE.getKey(), tokenCookieSecure);
    }

    public void setTokenCookieSecure(boolean tokenCookieSecure) {
        this.setOption(PollenServicesConfigOption.TOKEN_COOKIE_SECURE.getKey(), tokenCookieSecure);
    }

    public PollType getDefaultPollType() {
        return (PollType)this.applicationConfig.getOption(PollType.class, PollenServicesConfigOption.DEFAULT_POLL_TYPE.getKey());
    }

    public void setDefaultPollType(PollType defaultPollType) {
        this.setOption(PollenServicesConfigOption.DEFAULT_POLL_TYPE.getKey(), defaultPollType);
    }

    public int getDefaultVoteCountingType() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.DEFAULT_VOTE_COUNTING_TYPE.getKey());
    }

    public void setDefaultVoteCountingType(int defaultVoteCountingType) {
        this.setOption(PollenServicesConfigOption.DEFAULT_VOTE_COUNTING_TYPE.getKey(), defaultVoteCountingType);
    }

    public VoteVisibility getDefaultVoteVisibility() {
        return (VoteVisibility)this.applicationConfig.getOption(VoteVisibility.class, PollenServicesConfigOption.DEFAULT_VOTE_VISIBILITY.getKey());
    }

    public void setDefaultVoteVisibility(VoteVisibility defaultVoteVisibility) {
        this.setOption(PollenServicesConfigOption.DEFAULT_VOTE_VISIBILITY.getKey(), defaultVoteVisibility);
    }

    public CommentVisibility getDefaultCommentVisibility() {
        return (CommentVisibility)this.applicationConfig.getOption(CommentVisibility.class, PollenServicesConfigOption.DEFAULT_COMMENT_VISIBILITY.getKey());
    }

    public void setDefaultCommentVisibility(CommentVisibility defaultCommentVisibility) {
        this.setOption(PollenServicesConfigOption.DEFAULT_COMMENT_VISIBILITY.getKey(), defaultCommentVisibility);
    }

    public ResultVisibility getDefaultResultVisibility() {
        return (ResultVisibility)this.applicationConfig.getOption(ResultVisibility.class, PollenServicesConfigOption.DEFAULT_RESULT_VISIBILITY.getKey());
    }

    public void setDefaultResultVisibility(ResultVisibility defaultResultVisibility) {
        this.setOption(PollenServicesConfigOption.DEFAULT_RESULT_VISIBILITY.getKey(), defaultResultVisibility);
    }

    public Boolean getDefaultContinuousResults() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.DEFAULT_CONTINUOUS_RESULTS.getKey());
    }

    public boolean isDefaultContinuousResults() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.DEFAULT_CONTINUOUS_RESULTS.getKey());
    }

    public void setDefaultContinuousResults(Boolean defaultContinuousResults) {
        this.setOption(PollenServicesConfigOption.DEFAULT_CONTINUOUS_RESULTS.getKey(), defaultContinuousResults);
    }

    public void setDefaultContinuousResults(boolean defaultContinuousResults) {
        this.setOption(PollenServicesConfigOption.DEFAULT_CONTINUOUS_RESULTS.getKey(), defaultContinuousResults);
    }

    public Boolean getDefaultVoteNotification() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.DEFAULT_VOTE_NOTIFICATION.getKey());
    }

    public boolean isDefaultVoteNotification() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.DEFAULT_VOTE_NOTIFICATION.getKey());
    }

    public void setDefaultVoteNotification(Boolean defaultVoteNotification) {
        this.setOption(PollenServicesConfigOption.DEFAULT_VOTE_NOTIFICATION.getKey(), defaultVoteNotification);
    }

    public void setDefaultVoteNotification(boolean defaultVoteNotification) {
        this.setOption(PollenServicesConfigOption.DEFAULT_VOTE_NOTIFICATION.getKey(), defaultVoteNotification);
    }

    public Boolean getDefaultCommentNotification() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.DEFAULT_COMMENT_NOTIFICATION.getKey());
    }

    public boolean isDefaultCommentNotification() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.DEFAULT_COMMENT_NOTIFICATION.getKey());
    }

    public void setDefaultCommentNotification(Boolean defaultCommentNotification) {
        this.setOption(PollenServicesConfigOption.DEFAULT_COMMENT_NOTIFICATION.getKey(), defaultCommentNotification);
    }

    public void setDefaultCommentNotification(boolean defaultCommentNotification) {
        this.setOption(PollenServicesConfigOption.DEFAULT_COMMENT_NOTIFICATION.getKey(), defaultCommentNotification);
    }

    public Boolean getDefaultNewChoiceNotification() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.DEFAULT_NEW_CHOICE_NOTIFICATION.getKey());
    }

    public boolean isDefaultNewChoiceNotification() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.DEFAULT_NEW_CHOICE_NOTIFICATION.getKey());
    }

    public void setDefaultNewChoiceNotification(Boolean defaultNewChoiceNotification) {
        this.setOption(PollenServicesConfigOption.DEFAULT_NEW_CHOICE_NOTIFICATION.getKey(), defaultNewChoiceNotification);
    }

    public void setDefaultNewChoiceNotification(boolean defaultNewChoiceNotification) {
        this.setOption(PollenServicesConfigOption.DEFAULT_NEW_CHOICE_NOTIFICATION.getKey(), defaultNewChoiceNotification);
    }

    public int getDefaultNotifyMeHoursBeforePollEnds() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.DEFAULT_NOTIFY_ME_HOURS_BEFORE_POLL_ENDS.getKey());
    }

    public void setDefaultNotifyMeHoursBeforePollEnds(int defaultNotifyMeHoursBeforePollEnds) {
        this.setOption(PollenServicesConfigOption.DEFAULT_NOTIFY_ME_HOURS_BEFORE_POLL_ENDS.getKey(), defaultNotifyMeHoursBeforePollEnds);
    }

    public String getSmtpHost() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.SMTP_HOST.getKey());
    }

    public void setSmtpHost(String smtpHost) {
        this.setOption(PollenServicesConfigOption.SMTP_HOST.getKey(), smtpHost);
    }

    public int getSmtpPort() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.SMTP_PORT.getKey());
    }

    public void setSmtpPort(int smtpPort) {
        this.setOption(PollenServicesConfigOption.SMTP_PORT.getKey(), smtpPort);
    }

    public String getSmtpFrom() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.SMTP_FROM.getKey());
    }

    public void setSmtpFrom(String smtpFrom) {
        this.setOption(PollenServicesConfigOption.SMTP_FROM.getKey(), smtpFrom);
    }

    public int getSmtpWait() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.SMTP_WAIT.getKey());
    }

    public void setSmtpWait(int smtpWait) {
        this.setOption(PollenServicesConfigOption.SMTP_WAIT.getKey(), smtpWait);
    }

    public Integer getSmtpSslPort() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.SMTP_SSL_PORT.getKey());
    }

    public void setSmtpSslPort(Integer smtpSslPort) {
        this.setOption(PollenServicesConfigOption.SMTP_SSL_PORT.getKey(), smtpSslPort);
    }

    public boolean isSmtpUseSSLTLS() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.SMTP_USE_SSLTLS.getKey());
    }

    public void setSmtpUseSSLTLS(boolean smtpUseSSLTLS) {
        this.setOption(PollenServicesConfigOption.SMTP_USE_SSLTLS.getKey(), smtpUseSSLTLS);
    }

    public boolean isSmtpUseStartTLS() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.SMTP_USE_START_TLS.getKey());
    }

    public void setSmtpUseStartTLS(boolean smtpUseStartTLS) {
        this.setOption(PollenServicesConfigOption.SMTP_USE_START_TLS.getKey(), smtpUseStartTLS);
    }

    public String getSmtpUsername() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.SMTP_USERNAME.getKey());
    }

    public void setSmtpUsername(String smtpUsername) {
        this.setOption(PollenServicesConfigOption.SMTP_USERNAME.getKey(), smtpUsername);
    }

    public String getSmtpPassword() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.SMTP_PASSWORD.getKey());
    }

    public void setSmtpPassword(String smtpPassword) {
        this.setOption(PollenServicesConfigOption.SMTP_PASSWORD.getKey(), smtpPassword);
    }

    public String getMailBoxHost() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.MAIL_BOX_HOST.getKey());
    }

    public void setMailBoxHost(String mailBoxHost) {
        this.setOption(PollenServicesConfigOption.MAIL_BOX_HOST.getKey(), mailBoxHost);
    }

    public String getMailBoxProtocol() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.MAIL_BOX_PROTOCOL.getKey());
    }

    public void setMailBoxProtocol(String mailBoxProtocol) {
        this.setOption(PollenServicesConfigOption.MAIL_BOX_PROTOCOL.getKey(), mailBoxProtocol);
    }

    public String getMailBoxUser() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.MAIL_BOX_USER.getKey());
    }

    public void setMailBoxUser(String mailBoxUser) {
        this.setOption(PollenServicesConfigOption.MAIL_BOX_USER.getKey(), mailBoxUser);
    }

    public String getMailBoxPassword() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.MAIL_BOX_PASSWORD.getKey());
    }

    public void setMailBoxPassword(String mailBoxPassword) {
        this.setOption(PollenServicesConfigOption.MAIL_BOX_PASSWORD.getKey(), mailBoxPassword);
    }

    public String getMailBoxCronSchedule() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.MAIL_BOX_CRON_SCHEDULE.getKey());
    }

    public void setMailBoxCronSchedule(String mailBoxCronSchedule) {
        this.setOption(PollenServicesConfigOption.MAIL_BOX_CRON_SCHEDULE.getKey(), mailBoxCronSchedule);
    }

    public File getLogConfigurationFile() {
        return this.applicationConfig.getOptionAsFile(PollenServicesConfigOption.LOG_CONFIGURATION_FILE.getKey());
    }

    public void setLogConfigurationFile(File logConfigurationFile) {
        this.setOption(PollenServicesConfigOption.LOG_CONFIGURATION_FILE.getKey(), logConfigurationFile);
    }

    public String getSendEndPollRemindersCronSchedule() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.SEND_END_POLL_REMINDERS_CRON_SCHEDULE.getKey());
    }

    public void setSendEndPollRemindersCronSchedule(String sendEndPollRemindersCronSchedule) {
        this.setOption(PollenServicesConfigOption.SEND_END_POLL_REMINDERS_CRON_SCHEDULE.getKey(), sendEndPollRemindersCronSchedule);
    }

    public long getResourceMaxSize() {
        return this.applicationConfig.getOptionAsLong(PollenServicesConfigOption.RESOURCE_MAX_SIZE.getKey());
    }

    public void setResourceMaxSize(long resourceMaxSize) {
        this.setOption(PollenServicesConfigOption.RESOURCE_MAX_SIZE.getKey(), resourceMaxSize);
    }

    public int getResourcePreviewMax() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.RESOURCE_PREVIEW_MAX.getKey());
    }

    public void setResourcePreviewMax(int resourcePreviewMax) {
        this.setOption(PollenServicesConfigOption.RESOURCE_PREVIEW_MAX.getKey(), resourcePreviewMax);
    }

    public String getEmailAddressPatternForRegistration() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.EMAIL_ADDRESS_PATTERN_FOR_REGISTRATION.getKey());
    }

    public void setEmailAddressPatternForRegistration(String emailAddressPatternForRegistration) {
        this.setOption(PollenServicesConfigOption.EMAIL_ADDRESS_PATTERN_FOR_REGISTRATION.getKey(), emailAddressPatternForRegistration);
    }

    public String getResendEmailsCronSchedule() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.RESEND_EMAILS_CRON_SCHEDULE.getKey());
    }

    public void setResendEmailsCronSchedule(String resendEmailsCronSchedule) {
        this.setOption(PollenServicesConfigOption.RESEND_EMAILS_CRON_SCHEDULE.getKey(), resendEmailsCronSchedule);
    }

    public long getReportMaxScore() {
        return this.applicationConfig.getOptionAsLong(PollenServicesConfigOption.REPORT_MAX_SCORE.getKey());
    }

    public void setReportMaxScore(long reportMaxScore) {
        this.setOption(PollenServicesConfigOption.REPORT_MAX_SCORE.getKey(), reportMaxScore);
    }

    public String getMailsFeedback() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.MAILS_FEEDBACK.getKey());
    }

    public void setMailsFeedback(String mailsFeedback) {
        this.setOption(PollenServicesConfigOption.MAILS_FEEDBACK.getKey(), mailsFeedback);
    }

    public String getLocaleFeedback() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.LOCALE_FEEDBACK.getKey());
    }

    public void setLocaleFeedback(String localeFeedback) {
        this.setOption(PollenServicesConfigOption.LOCALE_FEEDBACK.getKey(), localeFeedback);
    }

    public String getDefaultTimeZoneId() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.DEFAULT_TIME_ZONE_ID.getKey());
    }

    public void setDefaultTimeZoneId(String defaultTimeZoneId) {
        this.setOption(PollenServicesConfigOption.DEFAULT_TIME_ZONE_ID.getKey(), defaultTimeZoneId);
    }

    public int getMaxVoters() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.MAX_VOTERS.getKey());
    }

    public void setMaxVoters(int maxVoters) {
        this.setOption(PollenServicesConfigOption.MAX_VOTERS.getKey(), maxVoters);
    }

    public boolean isUserConnectedRequired() {
        return this.applicationConfig.getOptionAsBoolean(PollenServicesConfigOption.USER_CONNECTED_REQUIRED.getKey());
    }

    public void setUserConnectedRequired(boolean userConnectedRequired) {
        this.setOption(PollenServicesConfigOption.USER_CONNECTED_REQUIRED.getKey(), userConnectedRequired);
    }

    public UsersRight getUsersCanCreatePoll() {
        return (UsersRight)this.applicationConfig.getOption(UsersRight.class, PollenServicesConfigOption.USERS_CAN_CREATE_POLL.getKey());
    }

    public void setUsersCanCreatePoll(UsersRight usersCanCreatePoll) {
        this.setOption(PollenServicesConfigOption.USERS_CAN_CREATE_POLL.getKey(), usersCanCreatePoll);
    }

    public String getDeleteObsoleteSessionTokensCronSchedule() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.DELETE_OBSOLETE_SESSION_TOKENS_CRON_SCHEDULE.getKey());
    }

    public void setDeleteObsoleteSessionTokensCronSchedule(String deleteObsoleteSessionTokensCronSchedule) {
        this.setOption(PollenServicesConfigOption.DELETE_OBSOLETE_SESSION_TOKENS_CRON_SCHEDULE.getKey(), deleteObsoleteSessionTokensCronSchedule);
    }

    public String getAnonymizeOlderVotesCronSchedule() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.ANONYMIZE_OLDER_VOTES_CRON_SCHEDULE.getKey());
    }

    public void setAnonymizeOlderVotesCronSchedule(String anonymizeOlderVotesCronSchedule) {
        this.setOption(PollenServicesConfigOption.ANONYMIZE_OLDER_VOTES_CRON_SCHEDULE.getKey(), anonymizeOlderVotesCronSchedule);
    }

    public int getAnonymizeOlderVotesAge() {
        return this.applicationConfig.getOptionAsInt(PollenServicesConfigOption.ANONYMIZE_OLDER_VOTES_AGE.getKey());
    }

    public void setAnonymizeOlderVotesAge(int anonymizeOlderVotesAge) {
        this.setOption(PollenServicesConfigOption.ANONYMIZE_OLDER_VOTES_AGE.getKey(), anonymizeOlderVotesAge);
    }

    public String getDefaultPollVoteUrl() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.DEFAULT_POLL_VOTE_URL.getKey());
    }

    public void setDefaultPollVoteUrl(String defaultPollVoteUrl) {
        this.setOption(PollenServicesConfigOption.DEFAULT_POLL_VOTE_URL.getKey(), defaultPollVoteUrl);
    }

    public String getDefaultUiEndPoint() {
        return this.applicationConfig.getOption(PollenServicesConfigOption.DEFAULT_UI_END_POINT.getKey());
    }

    public void setDefaultUiEndPoint(String defaultUiEndPoint) {
        this.setOption(PollenServicesConfigOption.DEFAULT_UI_END_POINT.getKey(), defaultUiEndPoint);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", this.get().getConfigFileName()));
        for (PollenServicesConfigOption option : this.orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), this.get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<PollenServicesConfigOption> orderedByKey() {
        List<PollenServicesConfigOption> values = Arrays.asList(PollenServicesConfigOption.values());
        Collections.sort(values, new Comparator<PollenServicesConfigOption>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(PollenServicesConfigOption o1, PollenServicesConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }
}

