/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.services.service.Polls;
import org.chorem.pollen.services.service.mail.PollenMail;
import org.nuiton.i18n.I18n;

public class PollCreatedEmail
extends PollenMail {
    protected Poll poll;
    protected String pollenUrl;
    protected String url;

    protected PollCreatedEmail(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
    }

    @Override
    public String getSubject() {
        return I18n.l((Locale)this.locale, (String)"pollen.service.mail.PollCreatedEmail.subject", (Object[])new Object[]{this.poll.getTitle()});
    }

    public Poll getPoll() {
        return this.poll;
    }

    public void setPoll(Poll poll) {
        this.poll = poll;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPollenUrl() {
        return this.pollenUrl;
    }

    public void setPollenUrl(String pollenUrl) {
        this.pollenUrl = pollenUrl;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isRestricted() {
        return Polls.isPollRestricted(this.poll);
    }

    @Override
    public List<PollenEntity> getEntitiesKey() {
        return Collections.singletonList(this.poll);
    }
}

