/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.Report;
import org.chorem.pollen.services.bean.ReportLevel;
import org.chorem.pollen.services.service.mail.PollenMail;

public abstract class AbstractReportEmail<T extends PollenEntity>
extends PollenMail {
    protected Poll poll;
    protected T target;
    protected Report report;
    protected String url;

    public AbstractReportEmail(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
    }

    public Poll getPoll() {
        return this.poll;
    }

    public void setPoll(Poll poll) {
        this.poll = poll;
    }

    public T getTarget() {
        return this.target;
    }

    public void setTarget(T target) {
        this.target = target;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public boolean isIllegal() {
        return ReportLevel.ILLEGAL.getScore() == this.report.getLevel();
    }

    public boolean isSpam() {
        return ReportLevel.SPAM.getScore() == this.report.getLevel();
    }

    public boolean isOffTopic() {
        return ReportLevel.OFF_TOPIC.getScore() == this.report.getLevel();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public List<PollenEntity> getEntitiesKey() {
        return Lists.newArrayList((Object[])new PollenEntity[]{this.poll, this.target, this.report});
    }
}

