/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.topia.internal;

import com.google.common.base.Preconditions;
import java.util.Properties;
import java.util.Set;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.PollenPersistenceConfiguration;
import org.chorem.pollen.persistence.PollenPersistenceUtil;
import org.chorem.pollen.persistence.entity.ChildFavoriteList;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.EmailToResend;
import org.chorem.pollen.persistence.entity.FavoriteList;
import org.chorem.pollen.persistence.entity.FavoriteListMember;
import org.chorem.pollen.persistence.entity.LoginProvider;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollEvent;
import org.chorem.pollen.persistence.entity.PollFeed;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenToken;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Report;
import org.chorem.pollen.persistence.entity.SessionToken;
import org.chorem.pollen.persistence.entity.UserCredential;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoteToChoice;
import org.chorem.pollen.persistence.entity.Voter;
import org.chorem.pollen.persistence.entity.VoterList;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.persistence.topia.TopiaMisconfigurationException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyHbmImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateProvider {
    private static final Logger log = LoggerFactory.getLogger(HibernateProvider.class);
    private static final String HIKARI_CP_HIBERNATE_CONNECTION_PROVIDER_CLASS_NAME = "org.hibernate.hikaricp.internal.HikariCPConnectionProvider";
    private static final String C3P0_HIBERNATE_CONNECTION_PROVIDER_CLASS_NAME = "org.hibernate.c3p0.internal.C3P0ConnectionProvider";
    private static final Set<Class<? extends PollenEntity>> IMPLEMENTATION_CLASSES = Set.of(ChildFavoriteList.class, Choice.class, Comment.class, EmailToResend.class, FavoriteList.class, FavoriteListMember.class, LoginProvider.class, Poll.class, PollEvent.class, PollFeed.class, PollenPrincipal.class, PollenResource.class, PollenToken.class, PollenUser.class, PollenUserEmailAddress.class, Question.class, Report.class, SessionToken.class, UserCredential.class, Vote.class, VoteToChoice.class, Voter.class, VoterList.class, VoterListMember.class);
    protected SessionFactory hibernateSessionFactory;
    protected Configuration hibernateConfiguration;
    private final PollenPersistenceConfiguration pollenPersistenceConfiguration;
    protected Metadata metaData;

    public HibernateProvider(PollenPersistenceConfiguration pollenPersistenceConfiguration) {
        this.pollenPersistenceConfiguration = pollenPersistenceConfiguration;
    }

    public Configuration getHibernateConfiguration() {
        if (this.hibernateConfiguration == null) {
            this.hibernateConfiguration = this.newHibernateConfiguration();
            PollenPersistenceUtil.warnOnAutomaticSchemaOperationRisk(this.hibernateConfiguration);
        }
        return this.hibernateConfiguration;
    }

    public Configuration newHibernateConfiguration() {
        Configuration newHibernateConfiguration = new Configuration();
        for (Class<? extends PollenEntity> entityClass : IMPLEMENTATION_CLASSES) {
            newHibernateConfiguration.addClass(entityClass);
        }
        Properties properties = new Properties();
        properties.put("jakarta.persistence.jdbc.url", this.pollenPersistenceConfiguration.getJdbcConnectionUrl());
        properties.put("jakarta.persistence.jdbc.driver", this.pollenPersistenceConfiguration.getJdbcDriverClass().getName());
        properties.put("jakarta.persistence.jdbc.user", this.pollenPersistenceConfiguration.getJdbcConnectionUser());
        properties.put("hibernate.dialect", HibernateProvider.getHibernateDialect(this.pollenPersistenceConfiguration));
        if (this.pollenPersistenceConfiguration.isUseHikariForJdbcConnectionPooling()) {
            properties.put("hibernate.connection.provider_class", HIKARI_CP_HIBERNATE_CONNECTION_PROVIDER_CLASS_NAME);
        } else {
            properties.put("hibernate.connection.provider_class", C3P0_HIBERNATE_CONNECTION_PROVIDER_CLASS_NAME);
            properties.put("hibernate.c3p0.min_size", (Object)5);
            properties.put("hibernate.c3p0.max_size", (Object)20);
            properties.put("hibernate.c3p0.timeout", (Object)1800);
            properties.put("hibernate.c3p0.max_statements", (Object)50);
        }
        if (this.pollenPersistenceConfiguration.isValidateSchema()) {
            properties.put("hibernate.hbm2ddl.auto", "validate");
        }
        properties.put("hibernate.implicit_naming_strategy", ImplicitNamingStrategyLegacyHbmImpl.class.getName());
        properties.put("hibernate.format_sql", (Object)true);
        properties.put("hibernate.use_sql_comments", (Object)true);
        properties.putAll(this.pollenPersistenceConfiguration.getHibernateExtraConfiguration());
        if (log.isInfoEnabled()) {
            log.info("will start hibernate with configuration " + String.valueOf(properties));
        }
        properties.put("jakarta.persistence.jdbc.password", this.pollenPersistenceConfiguration.getJdbcConnectionPassword());
        newHibernateConfiguration.setProperties(properties);
        return newHibernateConfiguration;
    }

    public static String getHibernateDialect(PollenPersistenceConfiguration topiaConfiguration) {
        String jdbcConnectionUrl = topiaConfiguration.getJdbcConnectionUrl();
        String userDefinedDialect = topiaConfiguration.getHibernateExtraConfiguration().get("hibernate.dialect");
        if (userDefinedDialect == null) {
            String message = String.format("unable to guess Hibernate dialect to use for JDBC URL %s please patch ToPIA or configure Hibernate manually using %s", jdbcConnectionUrl, "hibernate.dialect");
            throw new TopiaMisconfigurationException(message, topiaConfiguration);
        }
        String dialect = userDefinedDialect;
        return dialect;
    }

    public static StandardServiceRegistry getStandardServiceRegistry(SessionFactory sessionFactory) {
        SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
        return sessionFactoryOptions.getServiceRegistry();
    }

    protected static SessionFactoryServiceRegistry getSessionFactoryServiceRegistry(SessionFactory sessionFactory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
        return (SessionFactoryServiceRegistry)sessionFactoryImplementor.getServiceRegistry();
    }

    public static <S extends Service> S getHibernateService(SessionFactory sessionFactory, Class<S> serviceClass) {
        SessionFactoryServiceRegistry serviceRegistry = HibernateProvider.getSessionFactoryServiceRegistry(sessionFactory);
        return (S)serviceRegistry.getService(serviceClass);
    }

    public void close() {
        this.metaData = null;
        if (this.hibernateSessionFactory != null) {
            Preconditions.checkState((!this.hibernateSessionFactory.isClosed() ? 1 : 0) != 0);
            ConnectionProvider service = HibernateProvider.getHibernateService(this.hibernateSessionFactory, ConnectionProvider.class);
            if (service instanceof Stoppable) {
                Stoppable stoppable = (Stoppable)service;
                stoppable.stop();
            }
            this.hibernateSessionFactory.close();
        }
    }

    public SessionFactory getSessionFactory() {
        if (this.hibernateSessionFactory == null) {
            Configuration effectiveHibernateConfiguration = this.getHibernateConfiguration();
            this.hibernateSessionFactory = this.newSessionFactory(effectiveHibernateConfiguration);
        }
        return this.hibernateSessionFactory;
    }

    public SessionFactory newSessionFactory(Configuration effectiveHibernateConfiguration) {
        ClassLoader currentClassLoader = this.getClass().getClassLoader();
        return PollenPersistenceUtil.newSessionFactory(effectiveHibernateConfiguration, currentClassLoader);
    }

    public Metadata newMetaData(Configuration configuration, SessionFactory sessionFactory) {
        StandardServiceRegistry standardServiceRegistry = HibernateProvider.getStandardServiceRegistry(sessionFactory);
        MetadataSources sources = new MetadataSources((ServiceRegistry)standardServiceRegistry);
        for (Class<? extends PollenEntity> persistanceClass : IMPLEMENTATION_CLASSES) {
            String hbmXmlFile = persistanceClass.getName().replace('.', '/') + ".hbm.xml";
            sources.addResource(hbmXmlFile);
            configuration.addClass(persistanceClass);
        }
        MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
        return metadataBuilder.build();
    }
}

