/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import org.chorem.pollen.persistence.topia.SchemaValidationTopiaException;
import org.chorem.pollen.persistence.topia.internal.HibernateProvider;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollenPersistenceUtil {
    private static final Logger log = LoggerFactory.getLogger(PollenPersistenceUtil.class);

    public static void warnOnAutomaticSchemaOperationRisk(Configuration configuration) {
        if (log.isWarnEnabled()) {
            String hbm2ddl = configuration.getProperties().getProperty("hibernate.hbm2ddl.auto");
            if (ImmutableSet.of((Object)"update", (Object)"create", (Object)"create-drop").contains((Object)hbm2ddl)) {
                log.warn(String.format("Be careful, you are about to let Hibernate automatically create or update your database schema. [%s=%s]", "hibernate.hbm2ddl.auto", hbm2ddl));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isSchemaEmpty(Configuration configuration, Metadata metaData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SessionFactory newSessionFactory(Configuration hibernateConfiguration, ClassLoader classLoader) {
        SessionFactory result;
        Properties properties = hibernateConfiguration.getProperties();
        BootstrapServiceRegistry bootstrap = new BootstrapServiceRegistryBuilder().applyClassLoader(classLoader).build();
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder(bootstrap);
        StandardServiceRegistry standardServiceRegistry = builder.applySettings(properties).build();
        try {
            result = hibernateConfiguration.buildSessionFactory((ServiceRegistry)standardServiceRegistry);
        }
        catch (HibernateException e) {
            SchemaValidationTopiaException.throwIfHibernateExceptionIsAboutSchemaValidation(e);
            throw e;
        }
        return result;
    }

    public static class ConnectionProviderSupplier
    implements Supplier<ConnectionProvider>,
    Closeable {
        protected SessionFactory sessionFactory;
        protected StandardServiceRegistry standardServiceRegistry;
        protected ConnectionProvider connectionProvider;

        public ConnectionProviderSupplier(Configuration configuration) {
            Properties properties = configuration.getProperties();
            StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
            this.standardServiceRegistry = builder.applySettings(properties).build();
        }

        public ConnectionProvider get() {
            if (this.connectionProvider == null) {
                this.connectionProvider = this.sessionFactory != null ? HibernateProvider.getHibernateService(this.sessionFactory, ConnectionProvider.class) : (ConnectionProvider)this.standardServiceRegistry.getService(ConnectionProvider.class);
            }
            return this.connectionProvider;
        }

        @Override
        public void close() throws IOException {
            if (this.standardServiceRegistry != null) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.standardServiceRegistry);
            }
        }
    }
}

