/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.servicediscovery;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Vector;
import org.dinopolis.util.Debug;

public class RepositoryClassLoader
extends URLClassLoader {
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];
    protected Vector repositories_ = new Vector();

    public RepositoryClassLoader() {
        super(EMPTY_URL_ARRAY);
    }

    public RepositoryClassLoader(ClassLoader parent) {
        super(EMPTY_URL_ARRAY, parent);
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        return "[RepositoryClassLoader]";
    }

    public void addRepository(String repository) {
        this.addRepository(new File(repository));
    }

    public void addRepository(File repository) {
        try {
            if (repository.exists()) {
                if (repository.isDirectory()) {
                    Debug.println("RepositoryClassLoader", "adding Repository Directory: " + repository.toString());
                    this.repositories_.add(repository.toString());
                    File[] jars = repository.listFiles();
                    for (int j = 0; j < jars.length; ++j) {
                        if (!jars[j].getAbsolutePath().endsWith(".jar")) continue;
                        URL url = jars[j].toURL();
                        Debug.println("RepositoryClassLoader", "adding jar file " + url.toString());
                        super.addURL(url);
                    }
                } else {
                    Debug.println("RepositoryClassLoader", "adding file " + repository);
                    super.addURL(repository.toURL());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public List getRepositories() {
        return this.repositories_;
    }
}

