/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.WeakHashMap;
import org.dinopolis.util.resource.AbstractResources;

public class FileResources
extends AbstractResources {
    protected static final String PROPERTY_EXTENSION = ".properties";
    protected static final String TITLE_SUFFIX = ".title";
    protected static final String DESCRIPTION_SUFFIX = ".description";
    protected static final String POSSIBLE_VALUES_SUFFIX = ".possible_values";
    protected static final String TYPE_SUFFIX = ".type";
    protected static final String KEY_VALUE_SEPARATORS = "=: \t\r\n\f";
    protected static final String WHITE_SPACE_CHARS = " \t\r\n\f";
    protected ResourceBundle system_bundle_;
    protected Properties user_properties_;
    protected File user_resource_file_;
    protected String user_resource_base_name_;
    protected String system_resource_base_name_;
    protected static WeakHashMap mapping_ = new WeakHashMap();
    protected ClassLoader class_loader_;

    protected FileResources(File user_resource_file, Properties user_bundle, String user_resource_base_name, ResourceBundle system_bundle, String system_resource_base_name, ClassLoader class_loader) {
        this.user_resource_file_ = user_resource_file;
        this.user_properties_ = user_bundle;
        if (this.user_properties_ == null) {
            this.user_properties_ = new Properties();
        }
        this.user_resource_base_name_ = user_resource_base_name;
        this.system_bundle_ = system_bundle;
        this.system_resource_base_name_ = system_resource_base_name;
        this.class_loader_ = class_loader;
    }

    public static FileResources getResources(String base_name) throws MissingResourceException {
        return FileResources.getResources(null, base_name, base_name, null);
    }

    public static FileResources getResources(Class caller, String base_name) throws MissingResourceException {
        return FileResources.getResources(caller, base_name, base_name, null);
    }

    public static FileResources getResources(String base_name, Locale locale) throws MissingResourceException {
        return FileResources.getResources(null, base_name, base_name, locale);
    }

    public static FileResources getResources(Class caller, String base_name, Locale locale) throws MissingResourceException {
        return FileResources.getResources(caller, base_name, base_name, locale);
    }

    public static FileResources getResources(String base_name, String dir_name) throws MissingResourceException {
        return FileResources.getResources(null, base_name, dir_name, null);
    }

    public static FileResources getResources(Class caller, String base_name, String dir_name) throws MissingResourceException {
        return FileResources.getResources(caller, base_name, dir_name, null);
    }

    public static FileResources getResources(String base_name, String dir_name, Locale locale) throws MissingResourceException {
        return FileResources.getResources(null, base_name, dir_name, locale);
    }

    public static FileResources getResources(Class caller, String base_name, String dir_name, Locale locale) throws MissingResourceException {
        return FileResources.getResources(caller, base_name, dir_name, locale, null);
    }

    public static FileResources getResources(Class caller, String base_name, String dir_name, Locale locale, ClassLoader class_loader) throws MissingResourceException {
        String system_resource_base_name = FileResources.getSystemResourceBaseName(caller);
        String user_resource_base_name = FileResources.getUserResourceBaseName(dir_name);
        File user_resource_file = FileResources.getUsersResourceFile(base_name, user_resource_base_name);
        String key = locale + ":" + base_name + ":" + system_resource_base_name + ":" + user_resource_base_name;
        FileResources bound = (FileResources)mapping_.get(key);
        if (bound == null) {
            if (class_loader == null) {
                class_loader = caller == null ? FileResources.class.getClassLoader() : caller.getClassLoader();
            }
            bound = new FileResources(user_resource_file, FileResources.getUsersResourceBundle(user_resource_file), user_resource_base_name, FileResources.getSystemResourceBundle(system_resource_base_name, base_name, locale, class_loader), system_resource_base_name, class_loader);
            mapping_.put(key, bound);
        }
        return bound;
    }

    protected static String getSystemResourceBaseName(Class caller) {
        if (caller == null) {
            return "";
        }
        String caller_package = caller.getName();
        int las_dot = caller_package.lastIndexOf(46);
        caller_package = las_dot > 0 ? caller_package.substring(0, las_dot) : "";
        return caller_package.replace('.', '/');
    }

    protected static ResourceBundle getSystemResourceBundle(String system_resource_base_dir, String base_name, Locale locale, ClassLoader class_loader) throws MissingResourceException {
        String resource = system_resource_base_dir;
        if (resource.length() > 0) {
            resource = resource + ".";
        }
        resource = resource + base_name;
        if (locale != null) {
            return ResourceBundle.getBundle(resource, locale, class_loader);
        }
        return ResourceBundle.getBundle(resource, Locale.getDefault(), class_loader);
    }

    protected static String getUserResourceBaseName(String dir_name) {
        File home_dir = new File(System.getProperty("user.home"));
        File resource_dir = new File(home_dir, dir_name);
        if (!resource_dir.isDirectory()) {
            resource_dir = new File(home_dir, "." + dir_name);
        }
        if (!resource_dir.isDirectory()) {
            resource_dir = new File(home_dir, dir_name.toLowerCase());
        }
        if (!resource_dir.isDirectory()) {
            resource_dir = new File(home_dir, "." + dir_name.toLowerCase());
        }
        if (!resource_dir.isDirectory()) {
            resource_dir = new File(home_dir, dir_name.toLowerCase());
        }
        return resource_dir.getPath();
    }

    protected static File getUsersResourceFile(String base_name, String user_resource_dir) {
        File resource_dir = user_resource_dir == null ? new File(System.getProperty("user.home")) : new File(user_resource_dir);
        return new File(resource_dir, base_name + PROPERTY_EXTENSION);
    }

    protected static Properties getUsersResourceBundle(File user_resource_file) {
        if (!user_resource_file.isFile()) {
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(user_resource_file));
            return properties;
        }
        catch (FileNotFoundException exc) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean isModificationSupported() {
        return true;
    }

    protected synchronized String getValue(String key) throws MissingResourceException {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = this.user_properties_.getProperty(key);
        if (value != null) {
            return value;
        }
        return this.system_bundle_.getString(key);
    }

    protected Enumeration doGetKeys() {
        return new FileResourcesEnumeration();
    }

    protected synchronized void setValue(String key, String value) {
        this.user_properties_.setProperty(key, value);
    }

    protected synchronized void unsetValue(String key) {
        try {
            this.system_bundle_.getString(key);
        }
        catch (Exception e) {
            this.user_properties_.remove(key);
            return;
        }
        this.user_properties_.put(key, "$unset$");
    }

    protected void resetValue(String key) {
        this.user_properties_.remove(key);
    }

    protected synchronized void doStore() throws IOException {
        String tmp_file_name = this.user_resource_file_.getName() + ".tmp";
        File parent = this.user_resource_file_.getParentFile();
        if (!parent.exists()) {
            parent.mkdir();
        }
        FileOutputStream file_out = new FileOutputStream(this.user_resource_file_);
        this.user_properties_.store(file_out, "auto generated file - by FileResources");
        file_out.close();
    }

    public String getTitle(String key) {
        return this.getString(key + TITLE_SUFFIX, null);
    }

    public void setTitle(String key, String title) {
        if (title == null) {
            this.unsetValue(key + TITLE_SUFFIX);
        }
        this.setValue(key + TITLE_SUFFIX, title);
    }

    public String getDescription(String key) {
        return this.getString(key + DESCRIPTION_SUFFIX, null);
    }

    public void setDescription(String key, String description) {
        if (description == null) {
            this.unsetValue(key + DESCRIPTION_SUFFIX);
        }
        this.setValue(key + DESCRIPTION_SUFFIX, description);
    }

    public Class getType(String key) {
        String class_name = this.getString(key + TYPE_SUFFIX, null);
        return FileResources.getClassForType(class_name);
    }

    public void setType(String key, Class type) {
        String class_name = FileResources.getTypeForClass(type);
        if (class_name == null) {
            this.unsetValue(key + TYPE_SUFFIX);
        } else {
            this.setValue(key + TYPE_SUFFIX, class_name);
        }
    }

    public String[] getPossibleValues(String key) {
        return this.getStringArray(key + POSSIBLE_VALUES_SUFFIX, (String[])null);
    }

    public void setPossibleValues(String key, String[] possible_values) {
        if (possible_values == null) {
            this.unsetValue(key + POSSIBLE_VALUES_SUFFIX);
        } else {
            this.setStringArray(key + POSSIBLE_VALUES_SUFFIX, possible_values);
        }
    }

    public URL getURL(String key) throws MissingResourceException {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException exc) {
            URL ret;
            File file = new File(this.user_resource_base_name_, value);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException exc2) {
                    // empty catch block
                }
            }
            if ((ret = this.class_loader_.getResource(this.system_resource_base_name_ + "/" + value)) == null) {
                ret = this.class_loader_.getResource(value);
            }
            if (ret != null) {
                return ret;
            }
            throw new MissingResourceException("malformed URL '" + value + "'", this.getClass().getName(), key);
        }
    }

    class FileResourcesEnumeration
    implements Enumeration {
        protected Enumeration enumeration_;

        FileResourcesEnumeration() {
            String key;
            HashSet<String> added = new HashSet<String>();
            Vector<String> keys = new Vector<String>();
            Enumeration<String> enumeration = FileResources.this.system_bundle_.getKeys();
            while (enumeration.hasMoreElements()) {
                key = enumeration.nextElement();
                if (added.contains(key) || this.isSpecial(key)) continue;
                keys.add(key);
                added.add(key);
            }
            enumeration = FileResources.this.user_properties_.propertyNames();
            while (enumeration.hasMoreElements()) {
                key = enumeration.nextElement();
                if (added.contains(key) || this.isSpecial(key)) continue;
                keys.add(key);
                added.add(key);
            }
            this.enumeration_ = keys.elements();
        }

        protected boolean isSpecial(String key) {
            int delimiter = key.lastIndexOf(".");
            if (delimiter <= 0) {
                return false;
            }
            return key.endsWith(FileResources.TITLE_SUFFIX) || key.endsWith(FileResources.DESCRIPTION_SUFFIX) || key.endsWith(FileResources.TYPE_SUFFIX) || key.endsWith(FileResources.POSSIBLE_VALUES_SUFFIX);
        }

        public boolean hasMoreElements() {
            return this.enumeration_.hasMoreElements();
        }

        public Object nextElement() {
            return this.enumeration_.nextElement();
        }
    }
}

