/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.resource;

import [Ljava.lang.Double;;
import [Ljava.lang.String;;
import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.dinopolis.util.Resources;
import org.dinopolis.util.resource.ResourceGroup;

public abstract class AbstractResources
implements Resources {
    private PropertyChangeSupport property_change_support_ = new PropertyChangeSupport(this);
    private boolean dead_lock_detect_ = false;
    protected static final String NULL_KEY = "null";
    protected static final String UNSET_KEY = "unset";
    protected Vector attached_resources_;

    protected abstract String getValue(String var1) throws MissingResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getValueAllAttached(String key) throws MissingResourceException {
        MissingResourceException missing_exception = null;
        try {
            return this.getValue(key);
        }
        catch (MissingResourceException mre) {
            missing_exception = mre;
            if (this.attached_resources_ == null) {
                throw missing_exception;
            }
            Vector vector = this.attached_resources_;
            synchronized (vector) {
                Iterator resources_iterator = this.attached_resources_.iterator();
                while (resources_iterator.hasNext()) {
                    try {
                        return ((Resources)resources_iterator.next()).getString(key);
                    }
                    catch (MissingResourceException mre2) {
                        missing_exception = mre2;
                    }
                }
            }
            throw missing_exception;
        }
    }

    protected abstract Enumeration doGetKeys();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getKeys() {
        String key;
        Vector<String> all_keys = new Vector<String>();
        HashSet<String> added = new HashSet<String>();
        Enumeration enumeration = this.doGetKeys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            if (added.contains(key)) continue;
            added.add(key);
            all_keys.add(key);
        }
        if (this.attached_resources_ != null) {
            Vector vector = this.attached_resources_;
            synchronized (vector) {
                Iterator resources_iterator = this.attached_resources_.iterator();
                while (resources_iterator.hasNext()) {
                    enumeration = ((Resources)resources_iterator.next()).getKeys();
                    while (enumeration.hasMoreElements()) {
                        key = (String)enumeration.nextElement();
                        if (added.contains(key)) continue;
                        added.add(key);
                        all_keys.add(key);
                    }
                }
            }
        }
        return all_keys.elements();
    }

    protected void setValue(String key, String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("set methods are not supported by thisResources class");
    }

    protected void setValueAllAttached(String key, String value) throws UnsupportedOperationException {
        Resources resources = this.findResourcesForKey(key);
        if (resources == null || resources == this) {
            this.setValue(key, value);
        } else {
            resources.setString(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resources findResourcesForKey(String key) {
        try {
            String value = this.getValue(key);
            return this;
        }
        catch (MissingResourceException missingResourceException) {
            if (this.attached_resources_ != null) {
                Vector vector = this.attached_resources_;
                synchronized (vector) {
                    Iterator resources_iterator = this.attached_resources_.iterator();
                    while (resources_iterator.hasNext()) {
                        Resources resources = (Resources)resources_iterator.next();
                        try {
                            String value = resources.getString(key);
                            return resources;
                        }
                        catch (MissingResourceException ignored) {
                        }
                    }
                }
            }
            return null;
        }
    }

    protected void unsetValue(String key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove methods are not supported by thisResources class");
    }

    protected void unsetValueAllAttached(String key) throws UnsupportedOperationException {
        Resources resources = this.findResourcesForKey(key);
        if (resources == null || resources == this) {
            this.unsetValue(key);
        } else {
            resources.unset(key);
        }
    }

    protected void resetValue(String key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("reset methods are not supported by thisResources class");
    }

    protected void resetValueAllAttached(String key) throws UnsupportedOperationException {
        Resources resources = this.findResourcesForKey(key);
        if (resources == null || resources == this) {
            this.resetValue(key);
        } else {
            resources.reset(key);
        }
    }

    protected void doStore() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("storing is not supported by thisResources class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException, UnsupportedOperationException {
        this.doStore();
        if (this.attached_resources_ == null) {
            return;
        }
        UnsupportedOperationException exception = null;
        Vector vector = this.attached_resources_;
        synchronized (vector) {
            Iterator resources_iterator = this.attached_resources_.iterator();
            while (resources_iterator.hasNext()) {
                try {
                    ((Resources)resources_iterator.next()).store();
                }
                catch (UnsupportedOperationException e) {
                    exception = e;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachResources(Resources resources) throws UnsupportedOperationException {
        if (this.attached_resources_ == null) {
            this.attached_resources_ = new Vector();
        }
        Vector vector = this.attached_resources_;
        synchronized (vector) {
            this.attached_resources_.add(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachResources(Resources resources) throws UnsupportedOperationException {
        if (this.attached_resources_ == null) {
            return;
        }
        Vector vector = this.attached_resources_;
        synchronized (vector) {
            this.attached_resources_.remove(resources);
        }
    }

    public String getTitle(String key) {
        return null;
    }

    public void setTitle(String key, String title) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setTitle methods are not supported by thisResources class");
    }

    public String getDescription(String key) {
        return null;
    }

    public void setDescription(String key, String description) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setDescription methods are not supported by this Resources class");
    }

    public Class getType(String key) {
        return null;
    }

    public void setType(String key, Class type) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setType methods are not supported by this Resources class");
    }

    public String[] getPossibleValues(String key) {
        return null;
    }

    public void setPossibleValues(String key, String[] possible_values) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setPossibleValues methods are not supported by this Resources class");
    }

    public void unset(String key) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        try {
            Resources resources = this.findResourcesForKey(key);
            if (resources == null || resources == this) {
                String old_value = this.getValue(key);
                this.unsetValue(key);
                this.property_change_support_.firePropertyChange(key, old_value, null);
            } else {
                resources.unset(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void reset(String key) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        String old_value = null;
        try {
            old_value = this.getValueAllAttached(key);
        }
        catch (MissingResourceException exc) {
            // empty catch block
        }
        String new_value = null;
        try {
            new_value = this.getValueAllAttached(key);
        }
        catch (MissingResourceException exc) {
            // empty catch block
        }
        this.resetValueAllAttached(key);
        this.property_change_support_.firePropertyChange(key, old_value, new_value);
    }

    public boolean isModificationSupported() {
        return false;
    }

    public static String replace(String to_replace, Map map) {
        int var_start_pos = to_replace.indexOf("$");
        int var_end_pos = 0;
        while (var_start_pos >= 0 && (var_end_pos = to_replace.indexOf("$", var_start_pos + VAR_LENGTH)) >= var_start_pos) {
            String variable = to_replace.substring(var_start_pos + VAR_LENGTH, var_end_pos);
            String replaced = null;
            if (variable.length() == 0) {
                replaced = replaced == null ? "$" : replaced + ",$";
            } else {
                Object val = map.get(variable);
                if (val != null) {
                    replaced = val.toString();
                }
            }
            if (replaced != null) {
                to_replace = to_replace.substring(0, var_start_pos) + replaced + to_replace.substring(var_end_pos + VAR_LENGTH);
                var_end_pos = var_start_pos - VAR_LENGTH + replaced.length();
            }
            var_start_pos = to_replace.indexOf("$", var_end_pos + VAR_LENGTH);
        }
        return to_replace;
    }

    private String replaceVariables(String to_replace, Set set) throws MissingResourceException {
        int var_start_pos = to_replace.indexOf("$");
        int var_end_pos = 0;
        while (var_start_pos >= 0 && (var_end_pos = to_replace.indexOf("$", var_start_pos + VAR_LENGTH)) >= var_start_pos) {
            String var = to_replace.substring(var_start_pos + VAR_LENGTH, var_end_pos);
            boolean deep_replace = true;
            if (var.startsWith("%") && var.endsWith("%")) {
                deep_replace = false;
                var = var.substring(SWALLOW_LENGTH, var.length() - SWALLOW_LENGTH);
            }
            String[] variables = this.expand(var);
            String replaced = null;
            for (int count = 0; count < variables.length; ++count) {
                String variable;
                block8: {
                    variable = variables[count];
                    if (set.add(variable)) {
                        try {
                            replaced = variable.length() == 0 ? (replaced == null ? "$" : replaced + ",$") : (replaced == null ? (deep_replace ? this.replaceVariables(this.getValueAllAttached(variable), set) : this.replaceVariables(variable, set)) : (deep_replace ? replaced + "," + this.replaceVariables(this.getValueAllAttached(variable), set) : replaced + "," + this.replaceVariables(variable, set)));
                        }
                        catch (MissingResourceException exc) {
                            replaced = replaced == null ? System.getProperty(variable) : "," + System.getProperty(variable);
                            if (replaced != null) break block8;
                            if (variable.equals(NULL_KEY)) {
                                return null;
                            }
                            if (!variable.equals(UNSET_KEY)) break block8;
                            String key = (String)set.iterator().next();
                            throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key '" + key + "'", this.getClass().getName(), key);
                        }
                    }
                }
                set.remove(variable);
            }
            if (replaced != null) {
                to_replace = to_replace.substring(0, var_start_pos) + replaced + to_replace.substring(var_end_pos + VAR_LENGTH);
                var_end_pos = var_start_pos - VAR_LENGTH + replaced.length();
            }
            var_start_pos = to_replace.indexOf("$", var_end_pos + VAR_LENGTH);
        }
        return to_replace;
    }

    protected synchronized String[] expand(String key) {
        if (this.dead_lock_detect_) {
            return new String[]{key};
        }
        if (key.indexOf("*") <= 0) {
            return new String[]{key};
        }
        this.dead_lock_detect_ = true;
        StringBuffer key_perl5 = new StringBuffer();
        key_perl5.append("^");
        StringTokenizer tok = new StringTokenizer(key, "*", true);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.equals("*")) {
                key_perl5.append(".*");
                continue;
            }
            key_perl5.append(token);
        }
        key_perl5.append("$");
        try {
            RE regular_expression = new RE((Object)key_perl5.toString());
            Vector hits = new Vector();
            Enumeration enumeration = this.getKeys();
            while (enumeration.hasMoreElements()) {
                Object hit = enumeration.nextElement();
                if (!regular_expression.isMatch(hit)) continue;
                hits.add(hit);
            }
            String[] ret = new String[hits.size()];
            hits.toArray(ret);
            this.dead_lock_detect_ = false;
            return ret;
        }
        catch (REException exc) {
            this.dead_lock_detect_ = false;
            return new String[]{key};
        }
    }

    public String getString(String key) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        String value = this.getValueAllAttached(key);
        if (value == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key '" + key + "'", this.getClass().getName(), key);
        }
        if (value.indexOf("$") < 0) {
            return value;
        }
        HashSet<String> set = new HashSet<String>();
        set.add(key);
        return this.replaceVariables(value, set);
    }

    public Object get(String key) throws MissingResourceException, IllegalArgumentException {
        return this.get(key, this.getType(key));
    }

    public Object get(String key, Class type) throws MissingResourceException {
        if (type == null || type == String.class) {
            return this.getString(key);
        }
        if (type == String;.class) {
            return this.getStringArray(key);
        }
        if (type == Integer.TYPE) {
            return new Integer(this.getInt(key));
        }
        if (type == [I.class) {
            return this.getIntArray(key);
        }
        if (type == Boolean.TYPE) {
            return new Boolean(this.getBoolean(key));
        }
        if (type == Boolean.TYPE) {
            return new Boolean(this.getBoolean(key));
        }
        if (type == Icon.class) {
            return this.getIcon(key);
        }
        if (type == Color.class) {
            return this.getColor(key);
        }
        if (type == File.class) {
            return this.getFile(key);
        }
        if (type == URL.class) {
            return this.getURL(key);
        }
        if (type == Double.TYPE) {
            return new Double(this.getDouble(key));
        }
        if (type == Double;.class) {
            return this.getDoubleArray(key);
        }
        throw new IllegalArgumentException("creation of types '" + type + "' are not supported");
    }

    public String getString(String key, String default_value) {
        try {
            return this.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return default_value;
        }
    }

    public void setString(String key, String value) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        if (value == null) {
            throw new IllegalArgumentException("'value' must not be 'null'");
        }
        String old_value = null;
        try {
            old_value = this.getValue(key);
        }
        catch (MissingResourceException exc) {
            // empty catch block
        }
        this.setValueAllAttached(key, value);
        this.property_change_support_.firePropertyChange(key, old_value, value);
    }

    public String[] getStringArray(String key) throws MissingResourceException {
        return this.getStringArray(key, ",");
    }

    public String[] getStringArray(String key, String delimiter) throws MissingResourceException {
        String string_value = this.getString(key);
        if (string_value == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(string_value, delimiter);
        String[] ret = new String[tok.countTokens()];
        for (int count = 0; count < ret.length; ++count) {
            ret[count] = tok.nextToken().trim();
        }
        return ret;
    }

    public String[] getStringArray(String key, String[] default_values) {
        try {
            return this.getStringArray(key);
        }
        catch (MissingResourceException missingResourceException) {
            return default_values;
        }
    }

    public void setStringArray(String key, String[] values) throws UnsupportedOperationException {
        this.setStringArray(key, values, ",");
    }

    public void setStringArray(String key, String[] values, String delimiter) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        if (values == null) {
            throw new IllegalArgumentException("'values' must not be 'null'");
        }
        StringBuffer buffer = new StringBuffer();
        for (int count = 0; count < values.length; ++count) {
            buffer.append(values[count]);
            if (count + 1 >= values.length) continue;
            buffer.append(delimiter);
        }
        this.setString(key, buffer.toString());
    }

    public int getInt(String key) throws MissingResourceException, NumberFormatException {
        String string_value = this.getString(key);
        if (string_value == null) {
            throw new NumberFormatException("null is not an int");
        }
        return Integer.parseInt(string_value);
    }

    public int getInt(String key, int default_value) {
        try {
            return this.getInt(key);
        }
        catch (MissingResourceException exc) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return default_value;
    }

    public void setInt(String key, int value) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        this.setString(key, Integer.toString(value));
    }

    public int[] getIntArray(String key) throws MissingResourceException, NumberFormatException {
        String[] values = this.getStringArray(key);
        int[] ret = new int[values.length];
        for (int count = 0; count < ret.length; ++count) {
            ret[count] = Integer.parseInt(values[count]);
        }
        return ret;
    }

    public int[] getIntArray(String key, int[] default_values) {
        try {
            return this.getIntArray(key);
        }
        catch (MissingResourceException exc) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return default_values;
    }

    public void setIntArray(String key, int[] values) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        if (values == null) {
            throw new IllegalArgumentException("'values' must not be 'null'");
        }
        StringBuffer buffer = new StringBuffer();
        for (int count = 0; count < values.length; ++count) {
            buffer.append(Integer.toString(values[count]));
            if (count + 1 >= values.length) continue;
            buffer.append(",");
        }
        this.setString(key, buffer.toString());
    }

    public double getDouble(String key) throws MissingResourceException, NumberFormatException {
        String string_value = this.getString(key);
        if (string_value == null) {
            throw new NumberFormatException("null is not an double");
        }
        return Double.parseDouble(string_value);
    }

    public double getDouble(String key, double default_value) {
        try {
            return this.getDouble(key);
        }
        catch (MissingResourceException exc) {
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        return default_value;
    }

    public void setDouble(String key, double value) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        this.setString(key, Double.toString(value));
    }

    public double[] getDoubleArray(String key) throws MissingResourceException, NumberFormatException {
        String[] values = this.getStringArray(key);
        double[] ret = new double[values.length];
        for (int count = 0; count < ret.length; ++count) {
            ret[count] = Double.parseDouble(values[count]);
        }
        return ret;
    }

    public double[] getDoubleArray(String key, double[] default_values) {
        try {
            return this.getDoubleArray(key);
        }
        catch (MissingResourceException exc) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return default_values;
    }

    public void setDoubleArray(String key, double[] values) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        if (values == null) {
            throw new IllegalArgumentException("'values' must not be 'null'");
        }
        StringBuffer buffer = new StringBuffer();
        for (int count = 0; count < values.length; ++count) {
            buffer.append(Double.toString(values[count]));
            if (count + 1 >= values.length) continue;
            buffer.append(",");
        }
        this.setString(key, buffer.toString());
    }

    public boolean getBoolean(String key) throws MissingResourceException {
        String string_value = this.getString(key);
        if (string_value == null) {
            return false;
        }
        String value = string_value.toLowerCase();
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("yes")) {
            return true;
        }
        return value.equals("1");
    }

    public boolean getBoolean(String key, boolean default_value) {
        try {
            return this.getBoolean(key);
        }
        catch (MissingResourceException exc) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return default_value;
    }

    public void setBoolean(String key, boolean value) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        this.setString(key, value ? "1" : "0");
    }

    public Icon getIcon(String key) throws MissingResourceException, UnsupportedOperationException {
        return new ImageIcon(this.getURL(key));
    }

    public Icon getIcon(String key, Icon default_value) {
        try {
            return this.getIcon(key);
        }
        catch (MissingResourceException exc) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return default_value;
    }

    public Color getColor(String key) throws MissingResourceException {
        String value = this.getString(key);
        if (value == null) {
            throw new MissingResourceException("A 'null' value is not valid for a Color!", this.getClass().getName(), key);
        }
        if ((value = value.toLowerCase()).equals("white")) {
            return Color.white;
        }
        if (value.equals("light_gray")) {
            return Color.lightGray;
        }
        if (value.equals("gray")) {
            return Color.gray;
        }
        if (value.equals("dark_gray")) {
            return Color.darkGray;
        }
        if (value.equals("black")) {
            return Color.black;
        }
        if (value.equals("red")) {
            return Color.red;
        }
        if (value.equals("pink")) {
            return Color.pink;
        }
        if (value.equals("orange")) {
            return Color.orange;
        }
        if (value.equals("yellow")) {
            return Color.yellow;
        }
        if (value.equals("green")) {
            return Color.green;
        }
        if (value.equals("magenta")) {
            return Color.magenta;
        }
        if (value.equals("cyan")) {
            return Color.cyan;
        }
        if (value.equals("blue")) {
            return Color.blue;
        }
        int[] color_ints = this.getIntArray(key);
        if (color_ints.length < 3) {
            throw new MissingResourceException("value '" + value + "' is not valid for a Color!", this.getClass().getName(), key);
        }
        if (color_ints.length >= 4) {
            return new Color(color_ints[0], color_ints[1], color_ints[2], color_ints[3]);
        }
        return new Color(color_ints[0], color_ints[1], color_ints[2]);
    }

    public Color getColor(String key, Color default_value) {
        try {
            return this.getColor(key);
        }
        catch (MissingResourceException exc) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return default_value;
    }

    public void setColor(String key, Color value) throws UnsupportedOperationException {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be 'null'");
        }
        if (value == null) {
            throw new IllegalArgumentException("'value' must not be 'null'");
        }
        Object color = null;
        if (value.equals(Color.white)) {
            this.setString(key, "white");
            return;
        }
        if (value.equals(Color.lightGray)) {
            this.setString(key, "light_gray");
            return;
        }
        if (value.equals(Color.gray)) {
            this.setString(key, "gray");
            return;
        }
        if (value.equals(Color.darkGray)) {
            this.setString(key, "dark_gray");
            return;
        }
        if (value.equals(Color.black)) {
            this.setString(key, "black");
            return;
        }
        if (value.equals(Color.red)) {
            this.setString(key, "red");
            return;
        }
        if (value.equals(Color.pink)) {
            this.setString(key, "pink");
            return;
        }
        if (value.equals(Color.orange)) {
            this.setString(key, "orange");
            return;
        }
        if (value.equals(Color.yellow)) {
            this.setString(key, "yellow");
            return;
        }
        if (value.equals(Color.green)) {
            this.setString(key, "green");
            return;
        }
        if (value.equals(Color.magenta)) {
            this.setString(key, "magenta");
            return;
        }
        if (value.equals(Color.cyan)) {
            this.setString(key, "cyan");
            return;
        }
        if (value.equals(Color.blue)) {
            this.setString(key, "blue");
            return;
        }
        int alpha = value.getAlpha();
        if (alpha == 255) {
            this.setIntArray(key, new int[]{value.getRed(), value.getGreen(), value.getBlue()});
        } else {
            this.setIntArray(key, new int[]{value.getRed(), value.getGreen(), value.getBlue(), alpha});
        }
    }

    public File getFile(String key) throws MissingResourceException {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    public File getFile(String key, File default_value) {
        try {
            return this.getFile(key);
        }
        catch (MissingResourceException missingResourceException) {
            return default_value;
        }
    }

    public URL getURL(String key) throws MissingResourceException {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException exc) {
            throw new MissingResourceException("malformed URL '" + value + "'", this.getClass().getName(), key);
        }
    }

    public URL getURL(String key, URL default_value) {
        try {
            return this.getURL(key);
        }
        catch (MissingResourceException missingResourceException) {
            return default_value;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.property_change_support_.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.property_change_support_.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property_name, PropertyChangeListener listener) {
        this.property_change_support_.addPropertyChangeListener(property_name, listener);
    }

    public void removePropertyChangeListener(String property_name, PropertyChangeListener listener) {
        this.property_change_support_.removePropertyChangeListener(property_name, listener);
    }

    public static Class getClassForType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("int[]")) {
            return [I.class;
        }
        if (type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("boolean[]")) {
            return [Z.class;
        }
        if (type.equals("char")) {
            return Character.TYPE;
        }
        if (type.equals("char[]")) {
            return [C.class;
        }
        if (type.equals("byte")) {
            return Byte.TYPE;
        }
        if (type.equals("byte[]")) {
            return [B.class;
        }
        if (type.equals("short")) {
            return Short.TYPE;
        }
        if (type.equals("short[]")) {
            return [S.class;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("long[]")) {
            return [J.class;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("float[]")) {
            return [F.class;
        }
        if (type.equals("double")) {
            return Double.TYPE;
        }
        if (type.equals("double[]")) {
            return [D.class;
        }
        if (type.equals("String")) {
            return String.class;
        }
        if (type.equals("String[]")) {
            return String;.class;
        }
        if (type.equals("resource.group")) {
            return ResourceGroup.class;
        }
        try {
            if (type.endsWith("[]")) {
                return Class.forName("[L" + type.substring(0, type.length() - 2) + ";");
            }
            return Class.forName(type);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static String getTypeForClass(Class type) {
        if (type == null) {
            return null;
        }
        if (type == Integer.TYPE) {
            return "int";
        }
        if (type == [I.class) {
            return "int[]";
        }
        if (type == Boolean.TYPE) {
            return "boolean";
        }
        if (type == [Z.class) {
            return "boolean[]";
        }
        if (type == Character.TYPE) {
            return "char";
        }
        if (type == [C.class) {
            return "char[]";
        }
        if (type == Byte.TYPE) {
            return "byte";
        }
        if (type == [B.class) {
            return "byte[]";
        }
        if (type == Short.TYPE) {
            return "short";
        }
        if (type == [S.class) {
            return "short[]";
        }
        if (type == Long.TYPE) {
            return "long";
        }
        if (type == [J.class) {
            return "long[]";
        }
        if (type == Float.TYPE) {
            return "float";
        }
        if (type == [F.class) {
            return "float[]";
        }
        if (type == Double.TYPE) {
            return "double";
        }
        if (type == [D.class) {
            return "double[]";
        }
        if (type == String.class) {
            return "String";
        }
        if (type == String;.class) {
            return "String[]";
        }
        if (type == ResourceGroup.class) {
            return "resource.group";
        }
        if (type.isArray()) {
            return type.getComponentType().getName() + "[]";
        }
        return type.getName();
    }
}

