/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.IOException;
import java.io.StringWriter;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.OplockAdapter;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.OpLock;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class AttributesOnlyOplockGrantTest
extends Test {
    public AttributesOnlyOplockGrantTest() {
        super("AttributesOnlyOplockGrant");
    }

    @Override
    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        boolean initOK = false;
        try {
            String testFileName = this.getPerThreadFileName(threadId, curIter);
            if (sess.FileExists(testFileName)) {
                if (this.isVerbose()) {
                    Debug.println("File " + testFileName + " exists");
                }
                initOK = true;
            } else {
                SMBFile testFile;
                if (this.isVerbose()) {
                    Debug.println("Creating file " + testFileName + " via " + sess.getServer());
                }
                if ((testFile = sess.CreateFile(testFileName)) != null) {
                    testFile.Close();
                }
                if (sess.FileExists(testFileName)) {
                    initOK = true;
                }
            }
        }
        catch (Exception ex) {
            Debug.println(ex);
        }
        return initOK;
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = this.getPerThreadFileName(threadId, iteration);
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            CIFSFile attribFile = cifsSess.NTCreate(testFileName, 131208, 128, 7, 1, 0L, 0);
            this.testLog(log, "Opened for attributes only access on server " + sess.getServer());
            OplockBreakHandler oplockHandler = new OplockBreakHandler(log);
            CIFSFile oplockFile = cifsSess.NTCreateWithOplock(testFileName, 6, oplockHandler, 3, 128, 7, 5, 0L, 0);
            if (oplockFile.getOplockType() != 0) {
                this.testLog(log, "Opened file with oplock type " + OpLock.getTypeAsString(oplockFile.getOplockType()));
            } else {
                this.testLog(log, "Failed to get oplock");
                result = new BooleanTestResult(false, "Failed to get oplock on file");
            }
            sess.pingServer();
            attribFile.Close();
            oplockFile.Close();
            if (result == null) {
                result = oplockHandler.breakReceived() ? new BooleanTestResult(false, "Unexpected oplock break received") : new BooleanTestResult(true);
            }
            this.testLog(log, "Test completed");
        }
        catch (SMBException ex) {
            if (ex.getErrorClass() == 6 && ex.getErrorCode() == -1073741772) {
                this.testLog(log, "Open failed with object not found error (expected)");
                result = new BooleanTestResult(true, "Object not found error (expected)");
            } else {
                this.testLog(log, "Open failed with wrong error, ex=" + ex);
                result = new ExceptionTestResult(ex);
            }
        }
        catch (IOException ex) {
            this.testLog(log, "Open failed with error, ex=" + ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        sess.DeleteFile(this.getPerThreadFileName(threadId, iter));
    }

    public class OplockBreakHandler
    extends OplockAdapter {
        private StringWriter m_log;
        private boolean m_breakReceived;

        public OplockBreakHandler(StringWriter log) {
            this.m_log = log;
        }

        @Override
        public int oplockBreak(CIFSFile cifsFile) {
            AttributesOnlyOplockGrantTest.this.testLog(this.m_log, "Oplock break on file " + cifsFile.getFileName());
            try {
                cifsFile.Flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_breakReceived = true;
            return 0;
        }

        public final boolean breakReceived() {
            return this.m_breakReceived;
        }
    }
}

