/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.nio.win32;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.win32.NetBIOSSocket;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.netbios.win32.WinsockNetBIOSException;
import org.alfresco.jlan.server.SrvSessionQueue;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.nio.RequestHandler;
import org.alfresco.jlan.smb.server.nio.win32.AsyncWinsockCIFSReadRequest;
import org.alfresco.jlan.smb.server.nio.win32.AsyncWinsockCIFSWriteRequest;
import org.alfresco.jlan.smb.server.win32.WinsockNetBIOSPacketHandler;

public class AsyncWinsockCIFSRequestHandler
extends RequestHandler
implements Runnable {
    private static int _handlerId;
    private NetBIOSName m_srvName;
    private int m_srvLANA;
    private Thread m_thread;
    private int m_threadId;
    private ThreadRequestPool m_threadPool;
    private SrvSessionQueue m_sessQueue;
    private int m_clientSocketTimeout;
    private Hashtable<Integer, SMBSrvSession> m_eventTable;
    private int[] m_win32ActiveEvents;
    private int m_activeEventsLen;
    private int[] m_requeueEvents;
    private int m_requeueLen;
    private boolean m_shutdown;

    public AsyncWinsockCIFSRequestHandler(NetBIOSName srvName, int srvLANA, ThreadRequestPool threadPool, int maxSess, int sockTmo) {
        super(maxSess);
        this.m_srvName = srvName;
        this.m_srvLANA = srvLANA;
        this.m_threadPool = threadPool;
        this.m_clientSocketTimeout = sockTmo;
        this.m_sessQueue = new SrvSessionQueue();
        this.m_win32ActiveEvents = new int[maxSess];
        this.m_requeueEvents = new int[maxSess];
        this.m_eventTable = new Hashtable(maxSess);
        this.m_threadId = ++_handlerId;
        this.m_thread = new Thread(this);
        this.m_thread.setName("AsyncWinsockRequestHandler_" + this.m_threadId);
        this.m_thread.setDaemon(false);
        this.m_thread.start();
    }

    @Override
    public final int getCurrentSessionCount() {
        return this.m_eventTable.size();
    }

    @Override
    public final boolean hasFreeSessionSlot() {
        return this.getCurrentSessionCount() + this.m_sessQueue.numberOfSessions() < this.getMaximumSessionCount();
    }

    public final int getSocketTimeout() {
        return this.m_clientSocketTimeout;
    }

    public final void setSocketTimeout(int tmo) {
        this.m_clientSocketTimeout = tmo;
    }

    @Override
    public final void queueSessionToHandler(SMBSrvSession sess) {
        this.m_sessQueue.addSession(sess);
        this.wakeupRequestHandler();
    }

    @Override
    public final String getName() {
        if (this.m_thread != null) {
            return this.m_thread.getName();
        }
        return "AsyncWinsockRequestHandler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block29: {
            this.m_shutdown = false;
            try {
                this.m_win32ActiveEvents[0] = Win32NetBIOS.Win32CreateEvent();
                ++this.m_activeEventsLen;
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Failed to initialize wakeup event " + this.m_thread.getName());
                    Debug.println(ex);
                }
                this.m_shutdown = true;
            }
            eventIdx = -1;
            block16: while (true) {
                block32: {
                    block33: {
                        block30: {
                            block31: {
                                if (this.m_shutdown) break block30;
                                if (this.m_activeEventsLen == 1 && this.m_eventTable.size() == 0) {
                                    this.fireRequestHandlerEmptyEvent();
                                    if (this.hasDebug()) {
                                        Debug.println("[SMB] Request handler " + this.m_thread.getName() + " waiting for session ...");
                                    }
                                }
                                try {
                                    eventIdx = Win32NetBIOS.WinsockWaitForMultipleEvents(this.m_activeEventsLen, this.m_win32ActiveEvents, false, -1, false);
                                }
                                catch (WinsockNetBIOSException ex) {
                                    if (this.hasDebug()) {
                                        Debug.println("[SMB] Error waiting for event");
                                        Debug.println(ex);
                                    }
                                    eventIdx = 0;
                                }
                                if (this.m_shutdown) continue;
                                if (eventIdx != 0) break block31;
                                Win32NetBIOS.Win32ResetEvent(this.m_win32ActiveEvents[0]);
                                if (this.m_requeueLen <= 0) break block32;
                                ex = this.m_requeueEvents;
                                // MONITORENTER : this.m_requeueEvents
                                break block33;
                            }
                            this.processSocketEvent(this.m_win32ActiveEvents[eventIdx]);
                            continue;
                        }
                        if (this.m_eventTable.size() > 0) {
                            eventIds = this.m_eventTable.keys();
                            break;
                        }
                        break block29;
                    }
                    for (i = 0; i < this.m_requeueLen; ++i) {
                        eventId = new Integer(this.m_requeueEvents[i]);
                        sess = this.m_eventTable.get(eventId);
                        winsockPktHandler = (WinsockNetBIOSPacketHandler)sess.getPacketHandler();
                        nbSocket = winsockPktHandler.getSocket();
                        try {
                            this.processSocketEvent(this.m_requeueEvents[i]);
                            evtEnum = Win32NetBIOS.WinsockEnumNetworkEvents(nbSocket.getSocket(), 0);
                            if (evtEnum != 0) {
                                Debug.println("[SMB] Requeue event, evtEnum=0x" + Integer.toHexString(evtEnum));
                            }
                            Win32NetBIOS.WinsockEventSelect(nbSocket.getSocket(), this.m_requeueEvents[i], 35);
                            continue;
                        }
                        catch (Exception ex) {
                            Debug.println("[SMB] Error re-enabling FD_READ events sess=" + sess.getUniqueId());
                            Debug.println(ex);
                        }
                    }
                    this.m_requeueLen = 0;
                    // MONITOREXIT : ex
                }
                while (true) {
                    if (this.m_sessQueue.numberOfSessions() > 0) ** break;
                    continue block16;
                    sess = (SMBSrvSession)this.m_sessQueue.removeSessionNoWait();
                    if (sess == null) continue;
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Register session with request handler, handler=" + this.m_thread.getName() + ", sess=" + sess.getUniqueId());
                    }
                    if (!(sess.getPacketHandler() instanceof WinsockNetBIOSPacketHandler)) continue;
                    winsockPktHandler = (WinsockNetBIOSPacketHandler)sess.getPacketHandler();
                    nbSocket = winsockPktHandler.getSocket();
                    try {
                        sockEvent = Win32NetBIOS.WinsockCreateEvent();
                        Win32NetBIOS.setSocketReceiveBufferSize(nbSocket.getSocket(), 128000);
                        Win32NetBIOS.setSocketSendBufferSize(nbSocket.getSocket(), 256000);
                        nbSocket.configureBlocking(false);
                        Win32NetBIOS.WinsockEventSelect(nbSocket.getSocket(), sockEvent, 35);
                        this.m_eventTable.put(new Integer(sockEvent), sess);
                        this.m_win32ActiveEvents[this.m_activeEventsLen++] = sockEvent;
                    }
                    catch (IOException ex) {
                        if (!this.hasDebug()) continue;
                        Debug.println("[SMB] Failed to initialize socket event for new session");
                        Debug.println(ex);
                    }
                }
                break;
            }
            while (eventIds.hasMoreElements()) {
                eventId = eventIds.nextElement();
                sess = this.m_eventTable.get(eventId);
                if (sess == null) continue;
                if (this.hasDebug()) {
                    Debug.println("[SMB] Closing session " + sess.getUniqueId() + ", event=" + eventId);
                }
                try {
                    Win32NetBIOS.WinsockCloseEvent(eventId);
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
                try {
                    sess.closeSession();
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
            }
        }
        if (this.m_win32ActiveEvents[0] != 0) {
            try {
                Win32NetBIOS.Win32CloseEvent(this.m_win32ActiveEvents[0]);
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        }
        if (this.hasDebug() == false) return;
        Debug.println("[SMB] Closed CIFS request handler, " + this.m_thread.getName());
    }

    @Override
    public final void closeHandler() {
        if (this.m_thread != null) {
            this.m_shutdown = true;
            this.wakeupRequestHandler();
        }
    }

    protected final int checkForIdleSessions() {
        int idleCnt = 0;
        if (this.m_eventTable.size() > 0) {
            long checkTime = System.currentTimeMillis() - (long)this.m_clientSocketTimeout;
            Enumeration<SMBSrvSession> enumSess = this.m_eventTable.elements();
            Vector<SMBSrvSession> idleSessList = null;
            while (enumSess.hasMoreElements()) {
                SMBSrvSession sess = enumSess.nextElement();
                if (sess == null || sess.getLastIOTime() >= checkTime) continue;
                if (idleSessList == null) {
                    idleSessList = new Vector<SMBSrvSession>();
                }
                idleSessList.add(sess);
            }
            if (idleSessList != null) {
                for (int i = 0; i < idleSessList.size(); ++i) {
                    SMBSrvSession sess = (SMBSrvSession)idleSessList.get(i);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Closing idle session, " + sess.getUniqueId());
                    }
                    sess.closeSession();
                    sess.processPacket(null);
                    ++idleCnt;
                }
            }
        }
        return idleCnt;
    }

    protected void wakeupRequestHandler() {
        if (!Win32NetBIOS.Win32SetEvent(this.m_win32ActiveEvents[0]) && this.hasDebug()) {
            Debug.println("[SMB] Failed to wakeup request handler, " + this.m_thread.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requeueSocketEvent(int sockEvent, int sockPtr) {
        Win32NetBIOS.WinsockResetEvent(sockEvent);
        int[] nArray = this.m_requeueEvents;
        synchronized (this.m_requeueEvents) {
            this.m_requeueEvents[this.m_requeueLen++] = sockEvent;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!Win32NetBIOS.Win32SetEvent(this.m_win32ActiveEvents[0]) && this.hasDebug()) {
                Debug.println("[SMB] Failed to wakeup request handler (requeue), " + this.m_thread.getName());
            }
            return;
        }
    }

    private void processSocketEvent(int eventId) {
        Integer eventIdKey = new Integer(eventId);
        SMBSrvSession sess = this.m_eventTable.get(eventIdKey);
        WinsockNetBIOSPacketHandler winsockPktHandler = (WinsockNetBIOSPacketHandler)sess.getPacketHandler();
        NetBIOSSocket nbSocket = winsockPktHandler.getSocket();
        int triggeredEvent = 0;
        try {
            triggeredEvent = Win32NetBIOS.WinsockEnumNetworkEvents(nbSocket.getSocket(), 0);
        }
        catch (WinsockNetBIOSException ex) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Socket error event, sess=" + sess.getUniqueId() + ", eventId=" + eventId);
                Debug.println(ex);
            }
            triggeredEvent = 32;
        }
        if (triggeredEvent == 0) {
            return;
        }
        if ((triggeredEvent & 0x20) != 0) {
            block17: {
                int eventIdx;
                if (this.hasDebug()) {
                    Debug.println("[SMB] Close session event, sess=" + sess.getUniqueId());
                }
                for (eventIdx = 0; this.m_win32ActiveEvents[eventIdx] != eventId && eventIdx < this.m_activeEventsLen; ++eventIdx) {
                }
                if (eventIdx == this.m_activeEventsLen) {
                    return;
                }
                this.m_win32ActiveEvents[eventIdx] = this.m_win32ActiveEvents[this.m_activeEventsLen--];
                sess.hangupSession("Client closed socket");
                try {
                    Win32NetBIOS.WinsockCloseEvent(eventIdKey);
                }
                catch (WinsockNetBIOSException ex) {
                    if (!this.hasDebug()) break block17;
                    Debug.println("[SMB] Error closing socket event");
                    Debug.println(ex);
                }
            }
            this.m_eventTable.remove(eventId);
            if (this.hasDebug()) {
                Debug.println("[SMB] Removed session " + sess.getUniqueId());
            }
        }
        if ((triggeredEvent & 1) != 0) {
            Win32NetBIOS.WinsockResetEvent(eventIdKey);
            if (!sess.hasReadInProgress()) {
                sess.setLastIOTime(System.currentTimeMillis());
                AsyncWinsockCIFSReadRequest threadReq = new AsyncWinsockCIFSReadRequest(sess, eventIdKey, this);
                this.m_threadPool.queueRequest(threadReq);
            }
        }
        if ((triggeredEvent & 2) != 0) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Write event, sess=" + sess.getUniqueId());
            }
            Win32NetBIOS.WinsockResetEvent(eventIdKey);
            WinsockNetBIOSPacketHandler writesHandler = winsockPktHandler;
            if (writesHandler.getQueuedWriteCount() > 0) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Submit queued writes for processing, sess=" + sess.getUniqueId());
                }
                AsyncWinsockCIFSWriteRequest threadReq = new AsyncWinsockCIFSWriteRequest(sess, eventIdKey, this);
                this.m_threadPool.queueRequest(threadReq);
            }
        }
    }
}

