/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.admin;

import java.io.IOException;
import org.alfresco.jlan.client.IPCSession;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.client.DCEPacket;
import org.alfresco.jlan.util.DataPacker;

public class IPCPipeFile {
    private IPCSession m_sess;
    private DCEPacket m_pkt;
    private DCEBuffer m_buffer;
    private DCEBuffer m_rxBuffer;
    private int m_handle;
    private String m_name;
    private int m_callId;
    private int m_maxTxSize;
    private int m_maxRxSize;

    public IPCPipeFile(IPCSession sess, DCEPacket pkt, int handle, String name, int maxTxSize, int maxRxSize) {
        this.m_sess = sess;
        this.m_pkt = pkt;
        this.m_handle = handle;
        this.m_name = name;
        this.m_maxTxSize = maxTxSize;
        this.m_maxRxSize = maxRxSize;
        this.m_buffer = new DCEBuffer();
        this.m_callId = 1;
    }

    public final String getPipeName() {
        return this.m_name;
    }

    protected final IPCSession getSession() {
        return this.m_sess;
    }

    protected final DCEBuffer getBuffer() {
        return this.m_buffer;
    }

    protected final DCEBuffer getRxBuffer() {
        return this.m_rxBuffer;
    }

    protected final DCEPacket getPacket() {
        return this.m_pkt;
    }

    protected final int getHandle() {
        return this.m_handle;
    }

    protected final int getCallId() {
        return this.m_callId;
    }

    protected final int getNextCallId() {
        return ++this.m_callId;
    }

    public final int getMaximumTransmitSize() {
        return this.m_maxTxSize;
    }

    public final int getMaximumReceiveSize() {
        return this.m_maxRxSize;
    }

    public final void setMaximumTransmitSize(int siz) {
        this.m_maxTxSize = siz;
    }

    public final void setMaximumReceiveSize(int siz) {
        this.m_maxRxSize = siz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void doDCERequest(DCEPacket pkt) throws IOException, SMBException {
        int flags2 = 16384;
        if ((this.getSession().getDefaultFlags2() & 4) != 0) {
            flags2 += 4;
        }
        pkt.setFlags(0);
        pkt.setFlags2(flags2);
        this.getSession().SendTransaction(pkt, pkt);
        boolean continuedReq = false;
        if (!pkt.isValidResponse()) {
            if (pkt.hasLongErrorCode()) {
                if (pkt.getLongErrorCode() != -2147483643) throw new SMBException(6, pkt.getLongErrorCode());
                continuedReq = true;
            } else {
                if (pkt.getErrorCode() != 234) throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
                continuedReq = true;
            }
        }
        pkt.resetDCEOffset();
        int dceSize = pkt.getAllocationHint();
        int fragLen = pkt.getFragmentLength();
        if (pkt.getPDUType() != 2) {
            throw new SMBException(7, 0);
        }
        this.m_rxBuffer = new DCEBuffer(dceSize);
        int offset = 0;
        try {
            int rxSize = pkt.getParameter(6);
            offset = pkt.getParameter(7) + 4;
            this.m_rxBuffer.appendData(pkt.getBuffer(), offset + 24, rxSize - 24);
            fragLen -= rxSize;
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        if (!continuedReq) return;
        int maxReadSize = pkt.getBufferLength() - pkt.getByteOffset();
        boolean newFrag = false;
        boolean lastFrag = false;
        boolean dceDone = false;
        int flags = pkt.getBuffer()[offset + 3] & 0xFF;
        if ((flags & 2) != 0) {
            lastFrag = true;
        }
        while (!dceDone) {
            int readSize = maxReadSize;
            if (!newFrag && fragLen < readSize) {
                readSize = fragLen;
            }
            pkt.setCommand(46);
            pkt.setFlags(0);
            pkt.setFlags2(flags2);
            pkt.setMultiplexId(this.m_sess.getNextMultiplexId());
            pkt.setParameterCount(12);
            pkt.setByteCount(0);
            pkt.setAndXCommand(255);
            pkt.setParameter(2, this.getHandle());
            pkt.setParameter(3, 0);
            pkt.setParameter(4, 0);
            pkt.setParameter(5, readSize);
            pkt.setParameter(6, readSize);
            pkt.setParameter(7, 0);
            pkt.setParameter(8, 0);
            pkt.setParameter(9, 0);
            pkt.setParameterLong(10, 0);
            pkt.setFlags(0);
            pkt.setFlags2(16384);
            pkt.setLongErrorCode(0);
            pkt.ExchangeSMB(this.getSession(), pkt);
            if (!pkt.isValidResponse()) {
                if (pkt.hasLongErrorCode()) {
                    throw new SMBException(6, pkt.getLongErrorCode());
                }
                if (pkt.getErrorCode() != 234) throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
                continuedReq = true;
            }
            readSize = pkt.getParameter(5);
            offset = pkt.getParameter(6) + 4;
            try {
                fragLen -= readSize;
                if (newFrag) {
                    this.m_rxBuffer.appendData(pkt.getBuffer(), offset + 24, readSize - 24);
                    fragLen = DataPacker.getIntelShort(pkt.getBuffer(), offset + 8);
                    flags = pkt.getBuffer()[offset + 3] & 0xFF;
                    if ((flags & 2) != 0) {
                        lastFrag = true;
                    }
                    if ((fragLen -= readSize) == 0) {
                        if (!lastFrag) continue;
                        return;
                    }
                    newFrag = false;
                    continue;
                }
                this.m_rxBuffer.appendData(pkt.getBuffer(), offset, readSize);
                if (fragLen != 0) continue;
                if (lastFrag) {
                    return;
                }
                newFrag = true;
            }
            catch (DCEBufferException ex) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void doDCERequest(int opCode, DCEBuffer buf, int maxTx, int callId) throws IOException, SMBException, DCEBufferException {
        DCEPacket pkt = this.getPacket();
        int flags2 = 16384;
        if ((this.getSession().getDefaultFlags2() & 4) != 0) {
            flags2 += 4;
        }
        boolean firstFrag = true;
        while (buf.getAvailableLength() > maxTx - 24) {
            pkt.initializeDCEWrite(this.getHandle(), firstFrag ? 1 : 0, callId, maxTx);
            pkt.setOperationId(opCode);
            pkt.setAllocationHint(buf.getLength());
            pkt.setFragmentLength(maxTx);
            byte[] pktbuf = pkt.getBuffer();
            int pktpos = pkt.getDCEBaseOffset() + 24;
            pktpos += buf.copyData(pktbuf, pktpos, maxTx - 24);
            pkt.setByteCount(pktpos - pkt.getByteOffset());
            this.getSession().SendTransaction(pkt, pkt);
            firstFrag = false;
        }
        pkt.initializeDCERequest(this.getHandle(), opCode, buf, maxTx, callId);
        pkt.setFlags(0);
        pkt.setFlags2(flags2);
        this.getSession().SendTransaction(pkt, pkt);
        boolean continuedReq = false;
        if (!pkt.isValidResponse()) {
            if (pkt.hasLongErrorCode()) {
                if (pkt.getLongErrorCode() != -2147483643) throw new SMBException(6, pkt.getLongErrorCode());
                continuedReq = true;
            } else {
                if (pkt.getErrorCode() != 234) throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
                continuedReq = true;
            }
        }
        pkt.resetDCEOffset();
        int dceSize = pkt.getAllocationHint();
        int fragLen = pkt.getFragmentLength();
        if (pkt.getPDUType() != 2) {
            throw new SMBException(7, 0);
        }
        this.m_rxBuffer = new DCEBuffer(dceSize);
        int offset = 0;
        try {
            int rxSize = pkt.getParameter(6);
            offset = pkt.getParameter(7) + 4;
            this.m_rxBuffer.appendData(pkt.getBuffer(), offset + 24, rxSize - 24);
            fragLen -= rxSize;
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        if (!continuedReq) return;
        int maxReadSize = pkt.getBufferLength() - pkt.getByteOffset();
        boolean newFrag = false;
        boolean lastFrag = false;
        boolean dceDone = false;
        int flags = pkt.getBuffer()[offset + 3] & 0xFF;
        if ((flags & 2) != 0) {
            lastFrag = true;
        }
        while (!dceDone) {
            int readSize = maxReadSize;
            if (!newFrag && fragLen < readSize) {
                readSize = fragLen;
            }
            pkt.setCommand(46);
            pkt.setFlags(0);
            pkt.setFlags2(flags2);
            pkt.setMultiplexId(this.m_sess.getNextMultiplexId());
            pkt.setParameterCount(12);
            pkt.setByteCount(0);
            pkt.setAndXCommand(255);
            pkt.setParameter(2, this.getHandle());
            pkt.setParameter(3, 0);
            pkt.setParameter(4, 0);
            pkt.setParameter(5, readSize);
            pkt.setParameter(6, readSize);
            pkt.setParameter(7, 0);
            pkt.setParameter(8, 0);
            pkt.setParameter(9, 0);
            pkt.setParameterLong(10, 0);
            pkt.setFlags(0);
            pkt.setFlags2(16384);
            pkt.setLongErrorCode(0);
            pkt.ExchangeSMB(this.getSession(), pkt);
            if (!pkt.isValidResponse()) {
                if (pkt.hasLongErrorCode()) {
                    throw new SMBException(6, pkt.getLongErrorCode());
                }
                if (pkt.getErrorCode() != 234) throw new SMBException(pkt.getErrorClass(), pkt.getErrorCode());
                continuedReq = true;
            }
            readSize = pkt.getParameter(5);
            offset = pkt.getParameter(6) + 4;
            try {
                fragLen -= readSize;
                if (newFrag) {
                    this.m_rxBuffer.appendData(pkt.getBuffer(), offset + 24, readSize - 24);
                    fragLen = DataPacker.getIntelShort(pkt.getBuffer(), offset + 8);
                    flags = pkt.getBuffer()[offset + 3] & 0xFF;
                    if ((flags & 2) != 0) {
                        lastFrag = true;
                    }
                    if ((fragLen -= readSize) == 0) {
                        if (!lastFrag) continue;
                        return;
                    }
                    newFrag = false;
                    continue;
                }
                this.m_rxBuffer.appendData(pkt.getBuffer(), offset, readSize);
                if (fragLen != 0) continue;
                if (lastFrag) {
                    return;
                }
                newFrag = true;
            }
            catch (DCEBufferException ex) {}
        }
    }

    protected final void checkStatus(int sts) throws SMBException {
        if (sts != 0) {
            throw new SMBException((sts & 0xC0000000) == 0 ? 8 : 6, sts);
        }
    }

    public void ClosePipe() throws IOException, SMBException {
        SMBPacket pkt = new SMBPacket();
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.setCommand(4);
        pkt.setParameterCount(3);
        pkt.setParameter(0, this.m_handle);
        pkt.setParameter(1, 0);
        pkt.setParameter(2, 0);
        pkt.ExchangeSMB(this.m_sess, pkt);
        this.m_handle = -1;
    }

    public final boolean isClosed() {
        return this.m_handle == -1;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getPipeName());
        str.append(":");
        str.append(this.getHandle());
        str.append("]");
        return str.toString();
    }
}

