/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.IMimeTyper;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.AbstractMethod;
import net.sf.webdav.methods.DeterminableMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoHead
extends AbstractMethod {
    protected String _dftIndexFile;
    protected IWebdavStore _store;
    protected String _insteadOf404;
    protected ResourceLocks _resourceLocks;
    protected IMimeTyper _mimeTyper;
    protected int _contentLength;
    private static Logger LOG = LoggerFactory.getLogger(DoHead.class);

    public DoHead(IWebdavStore store, String dftIndexFile, String insteadOf404, ResourceLocks resourceLocks, IMimeTyper mimeTyper, int contentLengthHeader) {
        this._store = store;
        this._dftIndexFile = dftIndexFile;
        this._insteadOf404 = insteadOf404;
        this._resourceLocks = resourceLocks;
        this._mimeTyper = mimeTyper;
        this._contentLength = contentLengthHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        boolean bUriExists = false;
        String path = this.getRelativePath(req);
        LOG.trace("-- " + this.getClass().getName());
        StoredObject so = this._store.getStoredObject(transaction, path);
        if (so == null) {
            if (this._insteadOf404 != null && !this._insteadOf404.trim().equals("")) {
                path = this._insteadOf404;
                so = this._store.getStoredObject(transaction, this._insteadOf404);
            }
        } else {
            bUriExists = true;
        }
        if (so != null) {
            String tempLockOwner;
            if (so.isFolder()) {
                if (this._dftIndexFile != null && !this._dftIndexFile.trim().equals("")) {
                    resp.sendRedirect(resp.encodeRedirectURL(req.getRequestURI() + this._dftIndexFile));
                    return;
                }
            } else if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            if (this._resourceLocks.lock(transaction, path, tempLockOwner = "doGet" + System.currentTimeMillis() + req.toString(), false, 0, 10, true)) {
                try {
                    String eTagMatch = req.getHeader("If-None-Match");
                    if (eTagMatch != null && eTagMatch.equals(this.getETag(so))) {
                        resp.setStatus(304);
                        return;
                    }
                    if (so.isResource()) {
                        String mimeType;
                        if (path.endsWith("/") || path.endsWith("\\")) {
                            resp.sendError(404, req.getRequestURI());
                        }
                        long lastModified = so.getLastModified().getTime();
                        resp.setDateHeader("last-modified", lastModified);
                        String eTag = this.getETag(so);
                        resp.addHeader("ETag", eTag);
                        long resourceLength = so.getResourceLength();
                        if (this._contentLength == 1 && resourceLength > 0L) {
                            if (resourceLength <= Integer.MAX_VALUE) {
                                resp.setContentLength((int)resourceLength);
                            } else {
                                resp.setHeader("content-length", "" + resourceLength);
                            }
                        }
                        if ((mimeType = this._mimeTyper.getMimeType(transaction, path)) != null) {
                            resp.setContentType(mimeType);
                        } else {
                            int lastSlash = path.replace('\\', '/').lastIndexOf(47);
                            int lastDot = path.indexOf(".", lastSlash);
                            if (lastDot == -1) {
                                resp.setContentType("text/html");
                            }
                        }
                        this.doBody(transaction, resp, path);
                    }
                    this.folderBody(transaction, path, resp, req);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            this.folderBody(transaction, path, resp, req);
        }
        if (!bUriExists) {
            resp.setStatus(404);
        }
    }

    protected void folderBody(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) throws IOException {
    }

    protected void doBody(ITransaction transaction, HttpServletResponse resp, String path) throws IOException {
    }
}

