/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nuiton.wikitty.ui;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.event.ListDataEvent;

/**
 *
 * @author sherkhan
 */
public class ProxyModel extends AbstractListModel implements BindingListModel {

    protected List<Data> _proxyDatas = new ArrayList<Data>();

    @Override
    public Object getElementAt(int index) {
        return _proxyDatas.get(index);
    }

    @Override
    public int getSize() {
        return _proxyDatas.size();
    }

    @Override
    public int indexOf(Object obj) {
        return _proxyDatas.indexOf(obj);
    }

    public void setProxyDatas(List<Data> fieldExtensions) {
        _proxyDatas = fieldExtensions;
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }

    public void addData(Data newData) {
        _proxyDatas.add(newData);
        fireEvent(ListDataEvent.INTERVAL_ADDED, _proxyDatas.size() - 1, _proxyDatas.size() - 1);
    }

    public void removeData(Data data) {
        int interval = _proxyDatas.indexOf(data);
        _proxyDatas.remove(data);
        fireEvent(ListDataEvent.INTERVAL_REMOVED, interval, interval);
    }

    public void reload() {
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }
}
