/*
 * #%L
 * Wikitty :: dto
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;


public  class WikittyI18nDTO implements WikittyI18n {


@WikittyField(fqn="WikittyI18n.translatableValues")    protected Set<String> translatableValues = new LinkedHashSet<String>();

@WikittyField(fqn="WikittyI18n.lang")    protected Set<String> lang = new LinkedHashSet<String>();

@WikittyField(fqn="WikittyI18n.translations")    protected String translations;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getTranslatableValues :
     * @return Set<String> 
     */

    @Override
    public Set<String> getTranslatableValues() {
        return translatableValues;
}

    /**
     * setTranslatableValues :
     * @param translatableValues 
     */

    @Override
    public void setTranslatableValues(Set<String> translatableValues) {
        if (translatableValues == null){
            this.translatableValues = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.translatableValues=new LinkedHashSet<String>(translatableValues);
        }
        modificationCount++;
}

    /**
     * addAllTranslatableValues :
     * @param translatableValues 
     */

    @Override
    public void addAllTranslatableValues(Set<String> translatableValues) {
        if (this.translatableValues == null){
            this.translatableValues = new LinkedHashSet<String>();
        }
        this.translatableValues.addAll(translatableValues);
        modificationCount++;
}

    /**
     * addTranslatableValues :
     * @param element 
     */

    @Override
    public void addTranslatableValues(String element) {
        if (this.translatableValues == null){
            this.translatableValues = new LinkedHashSet<String>();
        }
        this.translatableValues.add(element);
        modificationCount++;
}

    /**
     * removeTranslatableValues :
     * @param element 
     */

    @Override
    public void removeTranslatableValues(String element) {
        translatableValues.remove(element);
        modificationCount++;
}

    /**
     * clearTranslatableValues :
     */

    @Override
    public void clearTranslatableValues() {
        translatableValues.clear();
        modificationCount++;
}

    /**
     * getLang :
     * @return Set<String> 
     */

    @Override
    public Set<String> getLang() {
        return lang;
}

    /**
     * setLang :
     * @param lang 
     */

    @Override
    public void setLang(Set<String> lang) {
        if (lang == null){
            this.lang = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.lang=new LinkedHashSet<String>(lang);
        }
        modificationCount++;
}

    /**
     * addAllLang :
     * @param lang 
     */

    @Override
    public void addAllLang(Set<String> lang) {
        if (this.lang == null){
            this.lang = new LinkedHashSet<String>();
        }
        this.lang.addAll(lang);
        modificationCount++;
}

    /**
     * addLang :
     * @param element 
     */

    @Override
    public void addLang(String element) {
        if (this.lang == null){
            this.lang = new LinkedHashSet<String>();
        }
        this.lang.add(element);
        modificationCount++;
}

    /**
     * removeLang :
     * @param element 
     */

    @Override
    public void removeLang(String element) {
        lang.remove(element);
        modificationCount++;
}

    /**
     * clearLang :
     */

    @Override
    public void clearLang() {
        lang.clear();
        modificationCount++;
}

    /**
     * getTranslations :
     * @return String 
     */

    @Override
    public String getTranslations() {
        return translations;
}

    /**
     * setTranslations :
     * @param translations 
     */

    @Override
    public void setTranslations(String translations) {
        this.translations=translations;
        modificationCount++;
}

    /**
     * WikittyI18nDTO :
     */

    public WikittyI18nDTO() {
}

    /**
     * WikittyI18nDTO :
     * @param wikittyId 
     */

    public WikittyI18nDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyI18n)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyI18n sourceCopy = (WikittyI18n)source;

        Set<String> translatableValues = sourceCopy.getTranslatableValues();
        if (translatableValues != null){
            setTranslatableValues(new LinkedHashSet<String>(translatableValues));
        }

        Set<String> lang = sourceCopy.getLang();
        if (lang != null){
            setLang(new LinkedHashSet<String>(lang));
        }

        setTranslations(sourceCopy.getTranslations());

        setWikittyVersion(sourceCopy.getWikittyVersion());
}

    /**
     * getTranslation :
     * @param lang 
     * @param field 
     * @return String 
     */

    @Override
    public String getTranslation(String lang, String field) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setTranslation :
     * @param lang 
     * @param field 
     * @param trad 
     */

    @Override
    public void setTranslation(String lang, String field, String trad) {
        throw new UnsupportedOperationException("Not supported yet.");
}


} //WikittyI18nDTO
