/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyTypes;

public class WikittyTest {
    private static final Log log = LogFactory.getLog(WikittyTest.class);
    protected static final String EXTNAME = "wikittyExt";
    protected static final String EXTREQUIRED = "wikittyRequired";
    protected static final String EXTREQUIRES = "wikittyRequires";
    protected static final WikittyExtension EXT_TEST = WikittyTest.createExtension("wikittyExt", null, new FieldType(WikittyTypes.STRING, 0, 1), new FieldType(WikittyTypes.NUMERIC, 1, 1), new FieldType(WikittyTypes.DATE, 1, 1));

    protected static WikittyExtension createExtension(String extName, String requires, FieldType ... types) {
        LinkedHashMap<String, FieldType> fieldsMap = new LinkedHashMap<String, FieldType>();
        for (int i = 0; i < types.length; ++i) {
            fieldsMap.put("fieldName" + i, types[i]);
        }
        return new WikittyExtension(extName, "1", null, requires, fieldsMap);
    }

    protected Wikitty createBasicWikitty() {
        WikittyExtension ext = ExtensionFactory.create((String)EXTNAME, (String)"1").addField("name", WikittyTypes.STRING).extension();
        WikittyImpl w = new WikittyImpl();
        w.addExtension(ext);
        w.setField(EXTNAME, "name", (Object)"foobar");
        return w;
    }

    @Test
    public void testWikittyId() {
        WikittyImpl w = new WikittyImpl();
        Assert.assertNotNull((String)"Wikitty should got an ID", (Object)w.getWikittyId());
        WikittyImpl w2 = new WikittyImpl(w.getWikittyId());
        Assert.assertEquals((String)"Wikitty with same ID must be equals", (Object)w, (Object)w2);
    }

    @Test
    public void testWikittyExtension() {
        WikittyImpl wikitty = new WikittyImpl();
        WikittyExtension ext = new WikittyExtension("invalidExt", "1", null);
        wikitty.addExtension(ext);
        Assert.assertTrue((boolean)wikitty.hasExtension("invalidExt"));
        ext = new WikittyExtension("invalideExt2", "1", new LinkedHashMap());
        wikitty.addExtension(ext);
        Assert.assertFalse((boolean)wikitty.hasExtension("invalidExt2"));
        ext = new WikittyExtension("master", "1", null);
        wikitty.addExtension(ext);
        Assert.assertTrue((boolean)wikitty.hasExtension("master"));
        ext = new WikittyExtension("slave", "1", null, "master", null);
        wikitty.addExtension(ext);
        Assert.assertTrue((boolean)wikitty.hasExtension("slave"));
        ext = new WikittyExtension("badslave", "1", null, "nomaster", null);
        try {
            wikitty.addExtension(ext);
            Assert.assertFalse((boolean)true);
        }
        catch (Exception eee) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertFalse((boolean)wikitty.hasExtension("badslave"));
        String testExtName = "testExt";
        ext = ExtensionFactory.create((String)testExtName, (String)"1").addField("fieldName0", WikittyTypes.NUMERIC).addField("fieldName1", WikittyTypes.STRING).addField("fieldName2", WikittyTypes.NUMERIC).extension();
        WikittyImpl w = new WikittyImpl();
        Assert.assertFalse((boolean)w.hasExtension(testExtName));
        w.addExtension(ext);
        Assert.assertTrue((boolean)w.hasExtension(testExtName));
        for (int i = 0; i < 3; ++i) {
            String fieldName = "fieldName" + i;
            Assert.assertTrue((String)("Field " + fieldName + " not found"), (boolean)w.hasField(testExtName, fieldName));
        }
        WikittyExtension ext2 = ExtensionFactory.create((String)"otherExt", (String)"1").addField("fieldName0", WikittyTypes.NUMERIC).addField("fieldName1", WikittyTypes.STRING).addField("fieldName2", WikittyTypes.NUMERIC).addField("fieldName3", WikittyTypes.NUMERIC).addField("fieldName4", WikittyTypes.NUMERIC).extension();
        w.addExtension(ext2);
        for (int i = 0; i < 5; ++i) {
            String fieldName = "fieldName" + i;
            if (i < 3) {
                Assert.assertTrue((String)("Field " + fieldName + " not found"), (boolean)w.hasField(testExtName, fieldName));
            }
            Assert.assertTrue((String)("Field " + fieldName + " not found"), (boolean)w.hasField("otherExt", fieldName));
        }
    }

    @Test
    public void testFieldAssigment() throws Exception {
        Wikitty w = this.createBasicWikitty();
        try {
            w.setField("UNKNOWN", "fieldName", (Object)"fieldValue");
            Assert.fail((String)"Should throw a runtime exception !");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            w.setField(EXTNAME, "non-existing-fieldName", (Object)"fieldValue");
            Assert.fail((String)"Should throw a runtime exception !");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        w.addExtension(EXT_TEST);
        String stringValue = "A Test Value";
        w.setField(EXTNAME, "fieldName0", (Object)stringValue);
        Assert.assertEquals((Object)stringValue, (Object)w.getFieldAsString(EXTNAME, "fieldName0"));
        int intValue = 123456;
        w.setField(EXTNAME, "fieldName1", (Object)intValue);
        Assert.assertEquals((long)intValue, (long)w.getFieldAsInt(EXTNAME, "fieldName1"));
        Date dateValue = new Date();
        w.setField(EXTNAME, "fieldName2", (Object)dateValue);
        Assert.assertEquals((Object)dateValue, (Object)w.getFieldAsDate(EXTNAME, "fieldName2"));
        for (int i = 0; i < 3; ++i) {
            w.setField(EXTNAME, "fieldName" + i, null);
        }
    }

    @Test
    public void testFieldCastRules() throws Exception {
        Wikitty w = this.createBasicWikitty();
        w.addExtension(EXT_TEST);
        String stringValue = "Hello";
        w.setField(EXTNAME, "fieldName0", new Object(){

            public String toString() {
                return "Hello";
            }
        });
        w.setField(EXTNAME, "fieldName1", (Object)123);
        Assert.assertEquals((long)123L, (long)w.getFieldAsInt(EXTNAME, "fieldName1"));
        w.setField(EXTNAME, "fieldName1", (Object)"123");
        Assert.assertEquals((long)123L, (long)w.getFieldAsInt(EXTNAME, "fieldName1"));
        Calendar cal = Calendar.getInstance(Locale.ROOT);
        cal.set(1982, 0, 23, 0, 0, 0);
        cal.set(14, 0);
        w.setField(EXTNAME, "fieldName2", (Object)WikittyUtil.formatDate((Date)cal.getTime()));
        Assert.assertEquals((Object)cal.getTime(), (Object)w.getFieldAsDate(EXTNAME, "fieldName2"));
    }

    @Test
    public void testFieldBoundsManagement() throws Exception {
        String fieldName = "fieldName0";
        WikittyExtension ext = ExtensionFactory.create((String)EXTNAME, (String)"1").addField(fieldName, WikittyTypes.NUMERIC).maxOccur(Integer.MAX_VALUE).extension();
        WikittyImpl w = new WikittyImpl();
        w.addExtension(ext);
        try {
            w.setField(EXTNAME, fieldName, (Object)0);
        }
        catch (WikittyException e) {
            Assert.fail((String)"setting an int to a list of int is forbidden !");
        }
        for (int i = 1; i < 10; ++i) {
            w.addToField(EXTNAME, fieldName, (Object)i);
        }
        int z = 0;
        Iterator i$ = w.getFieldAsList(EXTNAME, fieldName, Integer.class).iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            Assert.assertEquals((String)("element " + z + " failed"), (long)z, (long)value);
            ++z;
        }
        Integer[] listInt = new Integer[]{4, 2, 8, 9, 5, -12, Integer.MIN_VALUE, Integer.MAX_VALUE};
        w.setField(EXTNAME, fieldName, Arrays.asList(listInt));
        z = 0;
        Iterator i$2 = w.getFieldAsList(EXTNAME, fieldName, Integer.class).iterator();
        while (i$2.hasNext()) {
            int value = (Integer)i$2.next();
            Assert.assertEquals((long)listInt[z++].intValue(), (long)value);
        }
        w.removeFromField(EXTNAME, fieldName, (Object)Integer.MIN_VALUE);
        List values = w.getFieldAsList(EXTNAME, fieldName, Integer.class);
        z = 0;
        Iterator i$3 = w.getFieldAsList(EXTNAME, fieldName, Integer.class).iterator();
        while (i$3.hasNext()) {
            int value = (Integer)i$3.next();
            Assert.assertEquals((long)(z == values.size() - 1 ? Integer.MAX_VALUE : (long)listInt[z++].intValue()), (long)value);
        }
        w.clearField(EXTNAME, fieldName);
        values = w.getFieldAsList(EXTNAME, fieldName, Integer.class);
        Assert.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testPerfFieldAccess() throws Exception {
        int MAX = 100000;
        HashMap<String, Object> m = new HashMap<String, Object>();
        Wikitty w = this.createBasicWikitty();
        w.addExtension(EXT_TEST);
        PerfFieldAccesClass z = new PerfFieldAccesClass();
        long time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = "A Test Value";
            m.put("wikittyExt.fieldName0", stringValue);
            int intValue = 123456;
            m.put("wikittyExt.fieldName1", intValue);
            Date dateValue = new Date();
            m.put("wikittyExt.fieldName2", dateValue);
        }
        long timeSetM = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        String tmp = "";
        for (int i = 0; i < MAX; ++i) {
            String stringValue = (String)m.get("wikittyExt.fieldName0");
            int intValue = (Integer)m.get("wikittyExt.fieldName1");
            Date dateValue = (Date)m.get("wikittyExt.fieldName2");
            tmp = stringValue + intValue + dateValue;
        }
        long timeGetM = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = "A Test Value";
            w.setField(EXTNAME, "fieldName0", (Object)stringValue);
            int intValue = 123456;
            w.setField(EXTNAME, "fieldName1", (Object)intValue);
            w.setField(EXTNAME, "fieldName2", (Object)new Date());
        }
        long timeSetW = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = w.getFieldAsString(EXTNAME, "fieldName0");
            int intValue = w.getFieldAsInt(EXTNAME, "fieldName1");
            Date dateValue = w.getFieldAsDate(EXTNAME, "fieldName2");
            tmp = stringValue + intValue + dateValue;
        }
        long timeGetW = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = "A Test Value";
            z.setStringValue(stringValue);
            int intValue = 123456;
            z.setIntValue(intValue);
            Date dateValue = new Date();
            z.setDateValue(dateValue);
        }
        long timeSetZ = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = z.getStringValue();
            int intValue = z.getIntValue();
            Date dateValue = z.getDateValue();
            tmp = stringValue + intValue + dateValue;
        }
        long timeGetZ = System.currentTimeMillis() - time;
        log.info((Object)("Time m set: " + timeSetM + " Time m get: " + timeGetM));
        log.info((Object)("Time w set: " + timeSetW + " Time w get: " + timeGetW));
        log.info((Object)("Time z set: " + timeSetZ + " Time z get: " + timeGetZ));
    }

    public static class PerfFieldAccesClass {
        String stringValue;
        int intValue;
        Date dateValue;

        public String getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public void setIntValue(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public void setDateValue(Date dateValue) {
            this.dateValue = dateValue;
        }

        public Date getDateValue() {
            return this.dateValue;
        }
    }
}

