/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTypes;

public class ExtensionFactoryTest {
    @Test
    public void testExtensionFactory() throws Exception {
        WikittyExtension ext = ExtensionFactory.create((String)"testExtension", (String)"1.0").addField("name", WikittyTypes.STRING).notNull().addField("phoneNumbers", WikittyTypes.STRING).minOccur(2).maxOccur(10).addField("matricule", WikittyTypes.NUMERIC).unique().addField("fired", WikittyTypes.BOOLEAN).extension();
        Assert.assertEquals((Object)"testExtension", (Object)ext.getName());
        Assert.assertEquals((Object)"1.0", (Object)ext.getVersion());
        this.checkField(ext, "name", WikittyTypes.STRING, 0, 1, false, true);
        this.checkField(ext, "phoneNumbers", WikittyTypes.STRING, 2, 10, false, false);
        this.checkField(ext, "matricule", WikittyTypes.NUMERIC, 0, 1, true, false);
        this.checkField(ext, "fired", WikittyTypes.BOOLEAN, 0, 1, false, false);
    }

    protected void checkField(WikittyExtension ext, String fieldName, WikittyTypes type, int min, int max, boolean unique, boolean notNull) {
        FieldType fieldType = ext.getFieldType(fieldName);
        String str = "Checking " + ext.getName() + "." + fieldName + " field...";
        Assert.assertNotNull((String)str, (Object)fieldType);
        Assert.assertEquals((String)str, (Object)type, (Object)fieldType.getType());
        Assert.assertEquals((String)str, (long)min, (long)fieldType.getLowerBound());
        Assert.assertEquals((String)str, (long)max, (long)fieldType.getUpperBound());
        Assert.assertEquals((String)str, (Object)unique, (Object)fieldType.isUnique());
        Assert.assertEquals((String)str, (Object)notNull, (Object)fieldType.isNotNull());
    }
}

