/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateMathParser {
    public static TimeZone UTC;
    public static final TimeZone DEFAULT_MATH_TZ;
    public static final Locale DEFAULT_MATH_LOCALE;
    public static final Map<String, Integer> CALENDAR_UNITS;
    private TimeZone zone;
    private Locale loc;
    private Date now;
    private static Pattern splitter;
    private static Pattern splitter2;

    private static Map<String, Integer> makeUnitsMap() {
        HashMap<String, Integer> units = new HashMap<String, Integer>(13);
        units.put("YEAR", 1);
        units.put("YEARS", 1);
        units.put("MONTH", 2);
        units.put("MONTHS", 2);
        units.put("DAY", 5);
        units.put("DAYS", 5);
        units.put("DATE", 5);
        units.put("HOUR", 11);
        units.put("HOURS", 11);
        units.put("MINUTE", 12);
        units.put("MINUTES", 12);
        units.put("SECOND", 13);
        units.put("SECONDS", 13);
        units.put("MILLI", 14);
        units.put("MILLIS", 14);
        units.put("MILLISECOND", 14);
        units.put("MILLISECONDS", 14);
        return units;
    }

    public static void setDate(Calendar c, String pattern) {
        String year = StringUtils.substring((String)pattern, (int)0, (int)4);
        String month = StringUtils.substring((String)pattern, (int)4, (int)6);
        String day = StringUtils.substring((String)pattern, (int)6, (int)8);
        if (StringUtils.length((CharSequence)year) == 4 && StringUtils.isNumeric((CharSequence)year)) {
            c.set(1, Integer.parseInt(year));
        }
        if (StringUtils.length((CharSequence)month) == 2 && StringUtils.isNumeric((CharSequence)month)) {
            c.set(2, Integer.parseInt(month) - 1);
        }
        if (StringUtils.length((CharSequence)day) == 2 && StringUtils.isNumeric((CharSequence)day)) {
            c.set(5, Integer.parseInt(day));
        }
    }

    public static void setHour(Calendar c, String pattern) {
        String hour = StringUtils.substring((String)pattern, (int)0, (int)2);
        String min = StringUtils.substring((String)pattern, (int)2, (int)4);
        String sec = StringUtils.substring((String)pattern, (int)4, (int)6);
        if (StringUtils.length((CharSequence)hour) == 2 && StringUtils.isNumeric((CharSequence)hour)) {
            c.set(11, Integer.parseInt(hour));
        }
        if (StringUtils.length((CharSequence)min) == 2 && StringUtils.isNumeric((CharSequence)min)) {
            c.set(12, Integer.parseInt(min));
        }
        if (StringUtils.length((CharSequence)sec) == 2 && StringUtils.isNumeric((CharSequence)sec)) {
            c.set(13, Integer.parseInt(sec));
        }
    }

    public static void add(Calendar c, int val, String unit) {
        Integer uu = CALENDAR_UNITS.get(unit);
        if (null == uu) {
            throw new IllegalArgumentException("Adding Unit not recognized: " + unit);
        }
        c.add(uu, val);
    }

    public static void round(Calendar c, String unit) {
        Integer uu = CALENDAR_UNITS.get(unit);
        if (null == uu) {
            throw new IllegalArgumentException("Rounding Unit not recognized: " + unit);
        }
        int u = uu;
        switch (u) {
            case 1: {
                c.clear(2);
            }
            case 2: {
                c.clear(5);
                c.clear(7);
                c.clear(8);
                c.clear(6);
                c.clear(4);
                c.clear(3);
            }
            case 5: {
                c.clear(11);
                c.clear(10);
                c.clear(9);
            }
            case 11: {
                c.clear(12);
            }
            case 12: {
                c.clear(13);
            }
            case 13: {
                c.clear(14);
                break;
            }
            default: {
                throw new IllegalStateException("No logic for rounding value (" + u + ") " + unit);
            }
        }
    }

    public DateMathParser() {
        this(null, DEFAULT_MATH_LOCALE);
    }

    public DateMathParser(TimeZone tz, Locale l) {
        this.loc = null != l ? l : DEFAULT_MATH_LOCALE;
        this.zone = null != tz ? tz : DEFAULT_MATH_TZ;
    }

    public void setNow(Date n) {
        this.now = n;
    }

    public Date getNow() {
        if (this.now == null) {
            this.now = new Date();
        }
        return (Date)this.now.clone();
    }

    public Date parseMath(String math) throws ParseException {
        Calendar cal = Calendar.getInstance(this.zone, this.loc);
        cal.setTime(this.getNow());
        if (0 == math.length()) {
            return cal.getTime();
        }
        String[] ops = splitter.split(math);
        if (StringUtils.length((CharSequence)ops[0]) != 0) {
            throw new ParseException("Math expression must began with operator: \"" + ops[0] + "\"", 0);
        }
        int pos = 1;
        block12: while (pos < ops.length) {
            if (1 != ops[pos].length()) {
                throw new ParseException("Multi character command found: \"" + ops[pos] + "\"", pos);
            }
            char command = ops[pos++].charAt(0);
            switch (command) {
                case '/': {
                    if (ops.length < pos + 1) {
                        throw new ParseException("Need a unit after command: \"" + command + "\"", pos);
                    }
                    try {
                        DateMathParser.round(cal, ops[pos++]);
                        continue block12;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException("Unit not recognized: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                }
                case '=': {
                    if (ops.length < pos + 1) {
                        throw new ParseException("Need a unit after command: \"" + command + "\"", pos);
                    }
                    DateMathParser.setDate(cal, ops[pos++]);
                    continue block12;
                }
                case ':': {
                    if (ops.length < pos + 1) {
                        throw new ParseException("Need a unit after command: \"" + command + "\"", pos);
                    }
                    DateMathParser.setHour(cal, ops[pos++]);
                    continue block12;
                }
                case '+': 
                case '-': {
                    String[] valueUnit;
                    if (ops.length < pos + 1) {
                        throw new ParseException("Need a value and unit for command: \"" + command + "\"", pos);
                    }
                    if ((valueUnit = splitter2.split(ops[pos++])).length != 2) {
                        throw new ParseException("Need a value and unit for command: \"" + command + "\"", pos - 1);
                    }
                    int val = 0;
                    try {
                        val = Integer.valueOf(valueUnit[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException("Not a Number: \"" + valueUnit[0] + "\"", pos - 1);
                    }
                    if ('-' == command) {
                        val = 0 - val;
                    }
                    try {
                        String unit = valueUnit[1];
                        DateMathParser.add(cal, val, unit);
                        continue block12;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException("Unit not recognized: \"" + valueUnit[1] + "\"", pos - 1);
                    }
                }
            }
            throw new ParseException("Unrecognized command: \"" + command + "\"", pos - 1);
        }
        return cal.getTime();
    }

    static {
        DEFAULT_MATH_TZ = UTC = TimeZone.getTimeZone("UTC");
        DEFAULT_MATH_LOCALE = Locale.ROOT;
        CALENDAR_UNITS = DateMathParser.makeUnitsMap();
        splitter = Pattern.compile("(?<=[+=:/-])|(?=[+=:/-])");
        splitter2 = Pattern.compile("(?<=\\d)(?=\\D)");
    }
}

