/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryParser;

public class WikittyQueryTest {
    private static Log log = LogFactory.getLog(WikittyQueryTest.class);

    @Test
    public void testParseAliasAndTree() throws Exception {
        WikittyQueryParser parser = new WikittyQueryParser();
        System.out.println("---------------------------------------------------------------");
        WikittyQueryParser.parse((String)"Select WikittyGroup.name Where WikittyGroup.name=Group*");
        System.out.println("***************************************************************");
        WikittyQueryParser.parse((String)"Select WikittyGroup.name Where WikittyGroup.name=Group*");
        System.out.println("---------------------------------------------------------------");
        parser.addAlias("MyAlias\\((.*), (.*)\\)", "id={SELECT WikittyTreeNode.attachment WHERE (rootNode={SELECT ID WHERE (WikittyTreeNode.name=$1)} AND pathNode={SELECT ID WHERE (WikittyTreeNode.name=$2)})}");
        WikittyQueryParser.parse((String)"WikittyGroup.name=Group*");
        WikittyQueryParser.parse((String)"WikittyGroup.name=Group* AND id=toto");
        WikittyQuery q1 = parser.parseQuery("WikittyGroup.name=Group* AND MyAlias(OtherTree, OtherBranch)");
        WikittyQuery q2 = parser.parseQuery("WikittyGroup.name=Group* AND id={SELECT WikittyTreeNode.attachment WHERE (rootNode={SELECT ID WHERE (WikittyTreeNode.name=OtherTree)} AND pathNode={SELECT ID WHERE (WikittyTreeNode.name=OtherBranch)})}");
        System.out.println("Q1:" + q1);
        System.out.println("Q2:" + q2);
        Assert.assertEquals((Object)q2, (Object)q1);
    }

    @Test
    public void testParseEachElement() throws Exception {
        WikittyImpl w = new WikittyImpl();
        WikittyQuery query = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).rFalse()).rFalse()).end();
        String queryString = query.getCondition().toString();
        System.out.println("queryString:" + queryString);
        WikittyQuery queryParsed = WikittyQueryParser.parse((String)queryString);
        String queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().bw("ext.field", (Object)0, (Object)10)).end();
        queryString = query.getCondition().toString();
        System.out.println("queryString:" + queryString);
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().containsAll("ext.field", (Object)new Date(), (Object[])new Date[]{new Date()})).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().extContainsAll("ext1", new String[]{"ext2"})).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().eq("ext.field", (Object)w)).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().exteq("ext")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().rFalse()).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().gt("ext.field", (Object)13.3)).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().ge("ext.field", (Object)20.5)).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().keyword((Object)"value")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().lt("ext.field", (Object)new Date())).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().le("ext.field", (Object)30)).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().like("ext.field", (Object)"truc")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().ne("ext.field", (Object)w)).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().isNotNull("ext.field")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().isNull("ext.field")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().rTrue()).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().unlike("ext.field", (Object)"titi")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().sw("ext.field", "debut")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().ew("ext.field", (Object)"fin")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().notsw("ext.field", "pasdebut")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().notew("ext.field", (Object)"pasfin")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().not()).rTrue()).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().rFalse()).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().or()).rFalse()).rTrue()).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().eq("ext.field", (Object)w)).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().not()).and()).eq("ext.field", (Object)1)).eq("ext.field", (Object)2)).close()).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
        query = ((WikittyQueryMaker)new WikittyQueryMaker().eq("ext.field", (Object)"truc")).end();
        queryString = query.getCondition().toString();
        queryParsed = WikittyQueryParser.parse((String)queryString);
        queryParsedString = queryParsed.getCondition().toString();
        System.out.println("queryString:" + queryString);
        System.out.println("queryParsed:" + queryParsedString);
        Assert.assertEquals((Object)query, (Object)queryParsed);
        Assert.assertEquals((Object)queryString, (Object)queryParsedString);
    }

    @Test
    public void testParse() throws Exception {
        WikittyImpl w = new WikittyImpl();
        WikittyQueryMaker cc = new WikittyQueryMaker();
        cc.and();
        cc.bw("ext.field", (Object)0, (Object)10);
        cc.containsAll("ext.field", (Object)new Date(), (Object[])new Date[]{new Date()});
        cc.extContainsAll("ext1", new String[]{"ext2"});
        cc.eq("ext.field", (Object)w);
        cc.exteq("ext");
        cc.rFalse();
        cc.gt("ext.field", (Object)13.3);
        cc.ge("ext.field", (Object)20.5);
        cc.keyword((Object)"value");
        cc.lt("ext.field", (Object)new Date());
        cc.le("ext.field", (Object)30);
        cc.like("ext.field", (Object)"truc");
        cc.ne("ext.field", (Object)w);
        cc.isNotNull("ext.field");
        cc.isNull("ext.field");
        cc.rTrue();
        cc.unlike("ext.field", (Object)"titi");
        cc.sw("ext.field", "debut");
        cc.ew("ext.field", (Object)"fin");
        cc.notsw("ext.field", "pasdebut");
        cc.notew("ext.field", (Object)"pasfin");
        cc.not();
        cc.rFalse();
        cc.or();
        cc.eq("ext.field", (Object)w);
        ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)cc.not()).and()).eq("ext.field", (Object)1)).eq("ext.field", (Object)2)).close();
        cc.eq("ext.field", (Object)"truc");
        cc.close();
        WikittyQuery query = cc.end();
        String queryString = query.getCondition().toString();
        System.out.println("queryString:" + queryString);
        WikittyQuery queryCopy = query.copy();
        System.out.println("queryCopy:" + queryCopy.getCondition());
        WikittyQuery queryParsed = WikittyQueryParser.parse((String)queryString);
        System.out.println("queryParsed:" + queryParsed.getCondition());
        String queryCopyString = queryCopy.getCondition().toString();
        System.out.println("queryCopyString:" + queryCopyString);
        WikittyQuery queryCopyParsed = WikittyQueryParser.parse((String)queryCopyString);
        System.out.println("queryParsed:" + queryParsed.getCondition());
        Assert.assertEquals((Object)query, (Object)queryCopy);
        Assert.assertEquals((Object)queryParsed.toString(), (Object)queryCopyParsed.toString());
    }

    @Test
    public void testParseSpaceStart() {
        WikittyQueryMaker cc = new WikittyQueryMaker();
        cc.parse(" xxx");
    }
}

