/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
/*
 * Copyright (c) 2011 poussin. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.nuiton.wikitty;

import static org.nuiton.i18n.I18n.n_;

import java.io.File;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ApplicationConfig.OptionDef;
import org.nuiton.wikitty.services.WikittyCacheJCS;
import org.nuiton.wikitty.services.WikittyServiceAccessStat.AccessStatStorageWikitty;
import org.nuiton.wikitty.services.WikittyServiceInMemory;
import org.nuiton.wikitty.services.XMPPNotifierTransporter;

/**
 *
 * @author poussin
 */
public enum WikittyConfigOption implements OptionDef {

    WIKITTY_CONFIG_FILE(
    ApplicationConfig.CONFIG_FILE_NAME,
    n_("Main configuration wikitty file"),
    "wikitty-config.properties",
    String.class, true, true),
    WIKITTY_DATA_DIR(
    "wikitty.data.directory",
    n_("Data directory where wikitty store data"),
    "./target/data",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_QUERY_FILE(
    "wikitty.storage.jdbc.queryfile",
    n_("JDBC query configuration file. You can put more than one file"
    + " to load specific SQL statement for your database."
    + " Exemple: wikitty-jdbc-query.properties,wikitty-jdbc-query-mysql.properties"),
    "wikitty-jdbc-query.properties",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_DRIVER(
    "wikitty.storage.jdbc.driver",
    n_("JDBC driver name"),
    "org.h2.Driver",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_URL(
    "wikitty.storage.jdbc.host",
    n_("JDBC url"),
    "jdbc:h2:file:${" + WIKITTY_DATA_DIR.getKey() + "}/db",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_LOGIN(
    "wikitty.storage.jdbc.login",
    n_("JDBC login name"),
    "sa",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_PASSWORD(
    "wikitty.storage.jdbc.password",
    n_("JDBC password"),
    "",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_XADATASOURCE(
    "wikitty.storage.jdbc.xadatasource",
    n_("JDBC xadatasource driver"),
    "org.h2.jdbcx.JdbcDataSource",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_XADATASOURCE_H2_URL(
    "wikitty.storage.jdbc.xadatasource.org.h2.jdbcx.JdbcDataSource.URL",
    n_("JDBC xadatasource property h2 url"),
    "${" + WIKITTY_STORAGE_JDBC_URL.getKey() + "}",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_XADATASOURCE_H2_USER(
    "wikitty.storage.jdbc.xadatasource.org.h2.jdbcx.JdbcDataSource.user",
    n_("JDBC xadatasource property h2 username"),
    "${" + WIKITTY_STORAGE_JDBC_LOGIN.getKey() + "}",
    String.class, false, false),
    WIKITTY_STORAGE_JDBC_XADATASOURCE_H2_PASSWORD(
    "wikitty.storage.jdbc.xadatasource.org.h2.jdbcx.JdbcDataSource.password",
    n_("JDBC xadatasource property h2 password"),
    "${" + WIKITTY_STORAGE_JDBC_PASSWORD.getKey() + "}",
    String.class, false, false),
    WIKITTY_SEARCHENGINE_SOLR_HOME("wikitty.searchengine.solr.home",
    n_("SolR directory home. You can put solr.xml config file in. If"
    + " not null, replace solr.solr.home environment vairable"),
    null,
    String.class, false, false),
    /* Solr config name are used directly in solr config file. If
     * you change it, change too in module
     * wikitty-solr-impl/src/main/resources/solrconfig.xml */
    WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_DATA(
    "wikitty.searchengine.solr.directory.data",
    n_("Solr data directory"),
    "${" + WIKITTY_DATA_DIR.getKey() + "}/solr",
    File.class, false, false),
    WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_FACTORY(
    "wikitty.searchengine.solr.directory.factory",
    n_("SolR storage type possible value: solr.StandardDirectoryFactory"
    + " or org.nuiton.wikitty.storage.solr.RAMDirectoryFactory"
    + " (or when solr 4.0 will be used org.apache.solr.core.RAMDirectoryFactory)"),
    "solr.StandardDirectoryFactory",
    String.class, false, false),
    WIKITTY_WIKITTYSERVICE_COMPONENTS(
    "wikitty.WikittyService.components",
    n_("WikittyService to use (list must be in right order. "
    + "ex: org.nuiton.wikitty.WikittyServiceStorage,org.nuiton.wikitty.WikittyServiceNotifier,"
    + "org.nuiton.wikitty.WikittyServiceCached,org.nuiton.wikitty.WikittyServiceSecurity)"),
    WikittyServiceInMemory.class.getName(),
    String.class, false, false),
    WIKITTY_WIKITTYSERVICEINMEMORY_PERSISTENCE(
    "wikitty.WikittyServiceInMemory.persistence",
    n_("Indique si les donnees sont stocker entre deux utilisations."),
    "false",
    Boolean.class, false, false),
    WIKITTY_WIKITTYSERVICEINMEMORY_PERSISTENCE_FILE(
    "wikitty.WikittyServiceInMemory.persistence.file",
    n_("Fichier ou les donnees sont stocker"),
    "${" + WIKITTY_DATA_DIR.getKey() + "}/wikitty-inmemory.ser",
    File.class, false, false),
    WIKITTY_WIKITTYSERVICESTORAGE_COMPONENTS(
    "wikitty.WikittyServiceStorage.components",
    n_("WikittyServiceStorage component to use"
    + " (ExtensionStorage, WikittyStorage, SearchEngine)"),
    "org.nuiton.wikitty.jdbc.WikittyExtensionStorageJDBC,"
    + "org.nuiton.wikitty.jdbc.WikittyStorageJDBC,"
    + "org.nuiton.wikitty.storage.solr.WikittySearchEngineSolr",
    String.class, false, false),
    WIKITTY_WIKITTYSERVICENOTIFIER_COMPONENTS(
    "wikitty.WikittyServiceNotifier.components",
    n_("WikittyServiceNotifier component to use (transporter class"
    + "to use for propagate or listen remote event)"),
    XMPPNotifierTransporter.class.getName(),
    String.class, false, false),
    WIKITTY_TRANSACTION_WIKITTYSERVICE_COMPONENTS(
    "wikitty.transaction.WikittyService.components",
    n_("WikittyService to use for transaction (must be in memory)"
    + "ex: org.nuiton.wikitty.services.WikittyServiceInMemory"
    + " or org.nuiton.wikitty.services.WikittyServiceInMemoryJdbcSolr)"),
    WikittyServiceInMemory.class.getName(),
    String.class, false, false),
    WIKITTY_WIKITTYSERVICECACHED_COMPONENTS(
    "wikitty.WikittyServiceCached.components",
    n_("Indique le composant a utiliser pour le cache"),
    WikittyCacheJCS.class.getName(),
    String.class, false, false),
    WIKITTY_CACHE_PRIORITY_EXTENSIONS(
    "wikitty.service.cache.priority.extensions",
    n_("Indique la liste des extensions qui doivent etre "
    + "conservee prioritairement"),
    "",
    String.class, false, false),
    WIKITTY_CACHE_SIMPLE_REFERENCE_TYPE(
    "wikitty.service.cache.simple.reference.type",
    n_("Indique le type de reference a utiliser pour les extensions"
    + " non prioritaires dans le WikittyCacheSimple (soft ou hard)"),
    "soft",
    String.class, false, false),
    WIKITTY_WIKITTYSERVICEACCESSSTAT_COMPONENTS(
    "wikitty.WikittyServiceAccessStat.components",
    n_("Indique le composant a utiliser pour le stockage des acces"),
    AccessStatStorageWikitty.class.getName(),
    String.class, false, false),
    WIKITTY_ACCESSSTAT_EXTENSIONS(
    "wikitty.service.accessstat.extensions",
    n_("Indique la liste d'extension dont il faut monitorer l'acces"),
    "WikittyPubText,WikittyPubData",
    String.class, false, false),
    WIKITTY_SERVER_CONFIG(
    "wikitty.service.server.config",
    n_("Jetty server configuration file name"),
    "wikitty-server-config.xml",
    String.class, false, false),
    WIKITTY_SERVER_URL(
    "wikitty.service.server.url",
    n_("Hessian server url, use by server to know path and port to bind"
    + " servlet and client to contact server"),
    "http://service.codelutin.com/wikitty",
    String.class, false, false),
    WIKITTY_EXPORT_THREADNUMBER(
    "wikitty.addon.export.threadnumber",
    n_("number of thread used to export task"),
    "1",
    Integer.class, false, false),
    WIKITTY_EXPORT_DIRECTORY(
    "wikitty.addon.export.directory",
    n_("directory path where export asynchronous file are stored"),
    "${" + WIKITTY_DATA_DIR.getKey() + "}/export",
    String.class, false, false),
    WIKITTY_EXPORT_PUBLICURL(
    "wikitty.addon.export.publicurl",
    n_("url used by client to retrieve export file when job is ended"),
    "file://${" + WIKITTY_DATA_DIR.getKey() + "}/export/",
    String.class, false, false),
    WIKITTY_CACHE_RESTORE_COPIES(
    "wikitty.service.cache.allwaysRestoreCopies",
    n_("Indique si le cache retourne des copies des objets ou des proxies"),
    "false",
    Boolean.class, false, false),
    WIKITTY_EVENT_PROPAGATE("wikitty.service.event.propagate",
    n_("Indique si le service d'event propage sur le reseau les evenements"),
    "false",
    Boolean.class, false, false),
    WIKITTY_EVENT_LISTEN(
    "wikitty.service.event.listen",
    n_("Indique si le service d'event ecoute sur le reseau les evenements"),
    "false",
    Boolean.class, false, false),
    WIKITTY_EVENT_TRANSPORTER_XMPP_SERVER(
    "wikitty.service.event.transporter.xmpp.server",
    n_("XMPP server to use for XMPP transporter"),
    "im.codelutin.com",
    String.class, false, false),
    WIKITTY_EVENT_TRANSPORTER_XMPP_ROOM(
    "wikitty.service.event.transporter.xmpp.room",
    n_("Room to use for XMPP transporter"),
    "test@conference.im.codelutin.com",
    String.class, false, false),
    WIKITTY_SLAVE_SYNC_STATE_INTERVALE(
    "wikitty.service.slave.sync.state.intervale",
    n_("Intervale in second where slave service save state"
    + " synchronisation time"),
    "300",
    Integer.class, false, false),
    WIKITTY_SLAVE_SYNC_STATE_FILE(
    "wikitty.service.slave.sync.state.file",
    n_("File path to store synchronisation state"),
    "${" + WIKITTY_DATA_DIR.getKey() + "}/syncState",
    String.class, false, false),
    WIKITTY_SLAVE_MASTER_URL("wikitty.service.slave.master.hessian.endpoint",
    n_("Master url service, where to delegate modification action"),
    null,
    String.class, false, false),
    WIKITTY_SLAVE_MASTER_XMPP_SERVER(
    "wikitty.service.slave.master.xmpp.server",
    n_("XMPP server to use for synchronization with master"),
    "im.codelutin.com",
    String.class, false, false),
    WIKITTY_SLAVE_MASTER_XMPP_ROOM(
    "wikitty.service.slave.master.xmpp.room",
    n_("Room to use for synchronization with master,"
    + " this room must have history activated"),
    "test@conference.im.codelutin.com",
    String.class, false, false),
    WIKITTY_PROXY_TIME_TO_LOG_INFO(
    "wikitty.proxy.timeToLog.info",
    n_("maximum time before send log info with time consumed"),
    "1000",
    Integer.class, false, false),
    WIKITTY_PROXY_TIME_TO_LOG_WARN(
    "wikitty.proxy.timeToLog.warn",
    n_("maximum time before send log warn with time consumed"),
    "3000",
    Integer.class, false, false),
    JCS_DEFAULT("jcs.default",
    n_("jcs auxiliares to use"),
    "",
    String.class, false, false),
    JCS_DEFAULT_CACHEATTRIBUTES_MAXOBJECTS(
    "jcs.default.cacheattributes.MaxObjects",
    n_("jcs maximum number of items allowed in memory"),
    "1000",
    String.class, false, false);
    public String key;
    public String description;
    public String defaultValue;
    public Class<?> type;
    public boolean isTransient;
    public boolean isFinal;

    private WikittyConfigOption(String key, String description,
            String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isTransient = isTransient;
        this.isFinal = isFinal;
    }

    @Override
    public boolean isFinal() {
        return isFinal;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    public String getOptionValue(ApplicationConfig config) {
        String result = config.getOption(getKey());
        return result;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class<?> getType() {
        return type;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    @Override
    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }
}
