package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * Less operator is used to build restriction containing "element &lt; value"
 * where element could be a Integer, a Float or a Date. <br>
 * <br>
 * For example, use: RestrictionHelper.less( myElement ,
 * RestrictionHelper.DATE_FORMAT.format(new Date()) )
 */
public class Less extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public Less() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param other Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Less)) {
            return false;
        }

        final Less less = (Less) other;

        return super.equals(less);
    }

    public int hashCode() {
        // equals use objects that are not constant through time
        // then, unable to create hashCode from those objects 
        // returning a constant hash-code
        return Less.class.hashCode();
    }

}