package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * This class is an abstract class that's used to factor each operator that
 * handle two parameters (=, !=, &lt;, &lt;=, &gt;, &gt;=, end, begin).
 */
public class BinaryOperator extends Restriction implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    protected Element element;
    protected String value;

    /**
     * Default constructor
     */
    public BinaryOperator() {
        super();
    }

    /**
     * Constructor with all parameters initialized
     * 
     * @param element
     * @param value
     */
    public BinaryOperator(Element element, String value) {
        this.element = element;
        this.value = value;
    }

    /**
     * Return element
     * 
     * @return
     */
    public Element getElement() {
        return element;
    }

    /**
     * Set a value to parameter element.
     * 
     * @param element
     */
    public void setElement(Element element) {
        this.element = element;
    }

    /**
     * Return value
     * 
     * @return
     */
    public String getValue() {
        return value;
    }

    /**
     * Set a value to parameter value.
     * 
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BinaryOperator)) {
            return false;
        }

        final BinaryOperator binaryOperator = (BinaryOperator) other;

        if ((element == null && binaryOperator.getElement() != null)
                || (element != null && !element.equals(binaryOperator
                        .getElement()))) {
            return false;
        }
        if ((value == null && binaryOperator.getValue() != null)
                || (value != null && !value.equals(binaryOperator.getValue()))) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        // equals use objects that are not constant through time
        // then, unable to create hashCode from those objects 
        // returning a constant hash-code
        return BinaryOperator.class.hashCode();
    }

}