package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.TopiaException;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Mon Jan 06 19:11:32 CET 2014")
public abstract class SecurityRoleAbstract extends TopiaEntityAbstract implements SecurityRole {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : permissions
     */
    protected Collection<String> permissions;

    private static final long serialVersionUID = 4049127909472219447L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, PERMISSIONS, Collection.class, String.class, permissions);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
    }

    @Override
    public void addPermissions(String permissions) {
        fireOnPreWrite(PERMISSIONS, null, permissions);
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }

        this.permissions.add(permissions);
        fireOnPostWrite(PERMISSIONS, this.permissions.size(), null, permissions);
    }

    @Override
    public void addAllPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String item : permissions) {
            addPermissions(item);
        }
    }

    @Override
    public void setPermissions(Collection<String> permissions) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.permissions != null ? new ArrayList<String>(this.permissions) : null;
        fireOnPreWrite(PERMISSIONS, oldValue, permissions);
        this.permissions = permissions;
        fireOnPostWrite(PERMISSIONS, oldValue, permissions);
    }

    @Override
    public void removePermissions(String permissions) {
        fireOnPreWrite(PERMISSIONS, permissions, null);
        if (this.permissions == null || !this.permissions.remove(permissions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PERMISSIONS, this.permissions.size() + 1, permissions, null);
    }

    @Override
    public void clearPermissions() {
        if (this.permissions == null) {
            return;
        }
        Collection<String> oldValue = new ArrayList<String>(this.permissions);
        fireOnPreWrite(PERMISSIONS, oldValue, this.permissions);
        this.permissions.clear();
        fireOnPostWrite(PERMISSIONS, oldValue, this.permissions);
    }

    @Override
    public Collection<String> getPermissions() {
        return permissions;
    }

    @Override
    public int sizePermissions() {
        if (permissions == null) {
            return 0;
        }
        return permissions.size();
    }

    @Override
    public boolean isPermissionsEmpty() {
        int size = sizePermissions();
        return size == 0;
    }

    @Override
    public boolean isPermissionsNotEmpty() {
        boolean empty = isPermissionsEmpty();
        return ! empty;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(PERMISSIONS, this.permissions).
         toString();
        return result;
    }

} //SecurityRoleAbstract
