/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.service.Protocol;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaServiceServer;
import org.nuiton.topia.service.servers.RMIServer;
import org.nuiton.topia.service.servers.SOAPServer;
import org.nuiton.topia.service.servers.XMLRPCServer;

public class TopiaServiceProvider {
    private static final Log logger = LogFactory.getLog(TopiaServiceProvider.class);
    private Map<Class<? extends TopiaApplicationService>, TopiaApplicationService> mapInstanceForClass = new HashMap<Class<? extends TopiaApplicationService>, TopiaApplicationService>();
    private Map<Class<? extends TopiaApplicationService>, Class<? extends TopiaApplicationService>> mapClassForClass = new HashMap<Class<? extends TopiaApplicationService>, Class<? extends TopiaApplicationService>>();
    private Map<Protocol, TopiaServiceServer> mapDispatcherForProtocole = new HashMap<Protocol, TopiaServiceServer>();
    protected Map<Protocol, Integer> mapPortForProtocol = new HashMap<Protocol, Integer>();

    public void setProtocolPort(Protocol pr, Integer port) {
        this.mapPortForProtocol.put(pr, port);
    }

    public void addServiceClass(Class<? extends TopiaApplicationService> interfaze, Class<? extends TopiaApplicationService> clazz, Protocol protocole) {
        TopiaServiceServer server = this.initDispatcher(protocole);
        if (server != null) {
            server.addService(interfaze);
            this.mapClassForClass.put(interfaze, clazz);
            this.launchDispatcher(protocole);
        }
    }

    public void addServiceInstance(Class<? extends TopiaApplicationService> interfaze, TopiaApplicationService instance, Protocol protocole) {
        TopiaServiceServer server = this.initDispatcher(protocole);
        if (server != null) {
            server.addService(interfaze);
            this.mapInstanceForClass.put(interfaze, instance);
            this.launchDispatcher(protocole);
        }
    }

    private TopiaServiceServer initDispatcher(Protocol protocole) {
        TopiaServiceServer server = this.mapDispatcherForProtocole.get((Object)protocole);
        if (server == null) {
            switch (protocole) {
                case XML_RPC: {
                    if (this.mapPortForProtocol.get((Object)Protocol.XML_RPC) != null) {
                        server = new XMLRPCServer(this.mapPortForProtocol.get((Object)Protocol.XML_RPC));
                        break;
                    }
                    server = new XMLRPCServer();
                    break;
                }
                case RMI: {
                    try {
                        if (this.mapPortForProtocol.get((Object)Protocol.RMI) != null) {
                            server = new RMIServer(this.mapPortForProtocol.get((Object)Protocol.RMI));
                            break;
                        }
                        server = new RMIServer();
                    }
                    catch (RemoteException e) {
                        logger.debug((Object)"Can't start RMIServer.", (Throwable)e);
                    }
                    break;
                }
                case SOAP: {
                    if (this.mapPortForProtocol.get((Object)Protocol.SOAP) != null) {
                        server = new SOAPServer(this.mapPortForProtocol.get((Object)Protocol.SOAP));
                        break;
                    }
                    server = new SOAPServer();
                    break;
                }
                default: {
                    logger.debug((Object)"Unsupported protocole");
                }
            }
            this.mapDispatcherForProtocole.put(protocole, server);
            server.setTopiaServiceProvider(this);
        }
        return server;
    }

    private void launchDispatcher(Protocol protocole) {
        TopiaServiceServer server = this.mapDispatcherForProtocole.get((Object)protocole);
        server.launch();
    }

    public Object execute(Method method, Object[] args) {
        logger.debug((Object)("Request service : " + method.getDeclaringClass().getName() + "." + method.getName() + "(" + Arrays.toString(args) + ")"));
        Object result = null;
        Class<?> clazz = null;
        try {
            clazz = method.getDeclaringClass();
            TopiaApplicationService tasService = null;
            if (this.mapClassForClass.get(clazz) != null) {
                tasService = this.mapClassForClass.get(clazz).newInstance();
            } else if (this.mapInstanceForClass.get(clazz) != null) {
                tasService = this.mapInstanceForClass.get(clazz);
            } else {
                logger.warn((Object)("No service set for class " + clazz.getName()));
            }
            result = MethodUtils.invokeMethod((Object)tasService, (String)method.getName(), (Object[])args);
        }
        catch (InstantiationException e) {
            logger.debug((Object)"Can't instanciate class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.debug((Object)"Can't access class", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.debug((Object)("Can't call method '" + clazz.getName() + "' in class '" + clazz.getName() + "' (SecurityException)"), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)("No method '" + clazz.getName() + "' found in class '" + clazz.getName() + "'"), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.debug((Object)("Can't call method '" + clazz.getName() + "' in class '" + clazz.getName() + "' (security)"), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.debug((Object)("Can't call method '" + clazz.getName() + "' in class '" + clazz.getName() + "' (InvocationTargetException)"), (Throwable)e);
        }
        return result;
    }
}

