/* *##% 
 * ToPIA :: SOA
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

package org.nuiton.topia.service.clients;

import java.lang.reflect.Method;
import java.net.URI;

import org.apache.commons.beanutils.MethodUtils;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaProxy;

/**
 * SOAPProxy.java
 * 
 * @author chatellier
 * @version $Revision: 1715 $
 * 
 * Last update : $Date: 2009-12-15 01:26:16 +0100 (mar. 15 déc. 2009) $ By : $Author: tchemit $
 */
public class SOAPProxy implements TopiaProxy {

    /** Logger (common logging) */
    //private static final Log logger = LogFactory.getLog(RMIProxy.class);
    /** Classes geree par le proxy */
    protected Class<? extends TopiaApplicationService> clazz;

    /** URL du service */
    protected String serviceLocation;

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.service.TopiaProxy#setClass(java.lang.Class)
     */
    public void setClass(Class<? extends TopiaApplicationService> clazz) {
        this.clazz = clazz;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.nuiton.topia.service.TopiaProxy#setURI(java.net.URI)
     */
    public void setURI(URI uri) {
        this.serviceLocation = "http:" + uri.getSchemeSpecificPart();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.reflect.InvocationHandler#invoke(java.lang.Object,
     *      java.lang.reflect.Method, java.lang.Object[])
     */
    public Object invoke(Object obj, Method method, Object[] args)
            throws Throwable {
        Object result = null;

        // Create a service model for the client
        ObjectServiceFactory serviceFactory = new ObjectServiceFactory();
        Service serviceModel = serviceFactory.create(clazz);

        // Create a client proxy
        XFireProxyFactory proxyFactory = new XFireProxyFactory();
        Object xfproxy = proxyFactory.create(serviceModel, serviceLocation
                + "/" + clazz.getSimpleName());

        result = MethodUtils.invokeMethod(xfproxy, method.getName(), args);

        return result;
    }

    public void destroy() {
    }

    public void init(TopiaContext context) {
    }
}
