/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.clients;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.util.Arrays;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaProxy;

public class RMIProxy
implements TopiaProxy {
    private static final Log logger = LogFactory.getLog(RMIProxy.class);
    protected String serviceLocation = null;
    protected Class<? extends TopiaApplicationService> clazz;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        logger.debug((Object)("Invoke : " + this.clazz.getName() + "." + method.getName() + "(" + Arrays.toString(args) + ")"));
        Remote rObject = LocateRegistry.getRegistry().lookup(this.clazz.getName());
        logger.debug((Object)("Interfaces : " + Arrays.toString(rObject.getClass().getInterfaces())));
        logger.debug((Object)("Lookup for rmi service : rmi://" + this.serviceLocation + "/" + this.clazz.getName() + " is " + rObject));
        logger.warn((Object)Arrays.toString(rObject.getClass().getInterfaces()));
        try {
            result = MethodUtils.invokeMethod((Object)rObject, (String)method.getName(), (Object[])args);
        }
        catch (IllegalAccessException e) {
            new TopiaException("Illegal Access to method (" + method.getName() + ") in interface " + this.clazz.getName());
        }
        catch (InvocationTargetException e) {
            new TopiaException("Can't call method (" + method.getName() + ") in interface " + this.clazz.getName());
        }
        return result;
    }

    @Override
    public void setURI(URI uri) {
        this.serviceLocation = uri.getAuthority();
    }

    @Override
    public void setClass(Class<? extends TopiaApplicationService> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(TopiaContext context) {
    }
}

