package org.nuiton.topia.taas.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class TaasAuthorizationDAOAbstract<E extends TaasAuthorization> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TaasAuthorization.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<org.nuiton.topia.taas.entities.TaasPrincipal> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from taasPrincipal main, authorizations_principals secondary " +
                    "where main.topiaid=secondary.principals" +
                    " and secondary.authorizations='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(org.nuiton.topia.taas.entities.TaasPrincipal.class)).list();
            for (org.nuiton.topia.taas.entities.TaasPrincipal item : list) {
                item.removeAuthorizations(entity);
            }
        }

        super.delete(entity);
    }

    /**
     * findByExpression :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut expression le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByExpression(String v) throws TopiaException {
        E result = findByProperty(TaasAuthorization.EXPRESSION, v);
        return result;
    }

    /**
     * findAllByExpression :
     * Retourne les éléments ayant comme valeur pour l'attribut expression le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByExpression(String v) throws TopiaException {
        List<E> result = findAllByProperty(TaasAuthorization.EXPRESSION, v);
        return result;
    }

    /**
     * findByActions :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut actions le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByActions(int v) throws TopiaException {
        E result = findByProperty(TaasAuthorization.ACTIONS, v);
        return result;
    }

    /**
     * findAllByActions :
     * Retourne les éléments ayant comme valeur pour l'attribut actions le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByActions(int v) throws TopiaException {
        List<E> result = findAllByProperty(TaasAuthorization.ACTIONS, v);
        return result;
    }


} //TaasAuthorizationDAOAbstract<E extends TaasAuthorization>
