package org.nuiton.topia.security.entities.authorization;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class TopiaExpressionLinkDAOAbstract<E extends TopiaExpressionLink> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaExpressionLink.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByReplace :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut replace le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReplace(String v) throws TopiaException {
        E result = findByProperty("replace", v);
        return result;
    }

    /**
     * findAllByReplace :
     * Retourne les éléments ayant comme valeur pour l'attribut replace le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReplace(String v) throws TopiaException {
        List<E> result = findAllByProperty("replace", v);
        return result;
    }

    /**
     * findByBy :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut by le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByBy(String v) throws TopiaException {
        E result = findByProperty("by", v);
        return result;
    }

    /**
     * findAllByBy :
     * Retourne les éléments ayant comme valeur pour l'attribut by le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByBy(String v) throws TopiaException {
        List<E> result = findAllByProperty("by", v);
        return result;
    }


} //TopiaExpressionLinkDAOAbstract<E extends TopiaExpressionLink>
