/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.topia.migration.mappings.TMSVersionHibernateDao;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaSqlSupport;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.util.TopiaUtil;
import org.nuiton.util.StringUtil;
import org.nuiton.version.Version;

public abstract class AbstractTopiaMigrationCallback {
    private static final Log log = LogFactory.getLog(AbstractTopiaMigrationCallback.class);

    public abstract Version[] getAvailableVersions();

    public abstract boolean askUser(Version var1, List<Version> var2);

    protected abstract void migrateForVersion(Version var1, TopiaSqlSupport var2, boolean var3, boolean var4) throws Exception;

    public boolean doMigration(Configuration versionConfiguration, Version dbVersion, boolean showSql, boolean showProgression, List<Version> versions) {
        boolean doMigrate = this.askUser(dbVersion, versions);
        if (doMigrate) {
            for (Version v : versions) {
                try {
                    SessionFactory sessionFactory = null;
                    Session session = null;
                    try {
                        sessionFactory = TopiaUtil.newSessionFactory((Configuration)versionConfiguration);
                        session = sessionFactory.openSession();
                        session.getTransaction().begin();
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Start migration to version %s", v));
                        }
                        HibernateTopiaSqlSupport sqlSupport = new HibernateTopiaSqlSupport(session);
                        this.migrateForVersion(v, (TopiaSqlSupport)sqlSupport, showSql, showProgression);
                        TMSVersionHibernateDao.saveVersion(session, v.toString());
                        session.getTransaction().commit();
                    }
                    catch (Exception eee) {
                        if (log.isDebugEnabled()) {
                            log.error((Object)"Exception during schema migration, rollbacking transaction", (Throwable)eee);
                        }
                        if (session != null && session.isOpen() && session.getTransaction().isActive()) {
                            session.getTransaction().rollback();
                        }
                        throw new TopiaException("Exception during schema migration", (Throwable)eee);
                    }
                    finally {
                        if (session != null && session.isOpen()) {
                            session.close();
                        }
                        if (sessionFactory == null || sessionFactory.isClosed()) continue;
                        sessionFactory.close();
                    }
                }
                catch (Exception eee) {
                    throw new TopiaException("Exception during schema migration", (Throwable)eee);
                }
            }
        }
        return doMigrate;
    }

    public void executeSQL(TopiaSqlSupport sqlSupport, String ... sqls) throws TopiaException {
        this.executeSQL(sqlSupport, false, false, sqls);
    }

    public void executeSQL(TopiaSqlSupport sqlSupport, boolean showSql, boolean showProgression, String ... sqls) throws TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Will execute %1$s requests...", sqls.length));
        }
        if (showSql) {
            StringBuilder buffer = new StringBuilder();
            for (String s : sqls) {
                buffer.append(s).append("\n");
            }
            log.info((Object)("SQL TO EXECUTE :\n--------------------------------------------------------------------------------\n--------------------------------------------------------------------------------\n" + buffer.toString() + "--------------------------------------------------------------------------------\n--------------------------------------------------------------------------------\n"));
        }
        int index = 0;
        int max = sqls.length;
        for (String sql : sqls) {
            String message;
            ++index;
            long t0 = System.nanoTime();
            if (log.isInfoEnabled()) {
                message = "";
                if (showProgression) {
                    message = String.format("Executing request [%1$-4s/%2$-4s]", index, max);
                }
                if (showSql) {
                    message = message + "\n" + sql;
                }
                if (showProgression || showSql) {
                    log.info((Object)message);
                }
            }
            sqlSupport.executeSql(sql);
            if (!log.isDebugEnabled()) continue;
            message = String.format("Request [%1$-4s/%2$-4s] executed in %3$s.", index, max, StringUtil.convertTime((long)(System.nanoTime() - t0)));
            log.debug((Object)message);
        }
    }
}

