/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.index;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.hibernate.HibernateException;
import org.hibernate.metadata.ClassMetadata;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.index.IndexEntry;
import org.nuiton.topia.index.TopiaIndexImplementor;
import org.nuiton.topia.persistence.TopiaId;

public class LuceneIndexer
implements TopiaIndexImplementor {
    private static final String TOPIA_ID = "topiaId";
    private static Log log = LogFactory.getLog(LuceneIndexer.class);
    protected File directory = null;
    protected TopiaContextImplementor context;
    protected Map<Object, Object[]> indexationMap = new HashMap<Object, Object[]>();

    public String getServiceName() {
        return "index";
    }

    public Class<?>[] getPersistenceClasses() {
        return null;
    }

    @Override
    public void recordForIndexation(Object id, Object[] fields) {
        if (id == null) {
            log.warn((Object)"Id must not be null, this object will be not indexed");
        } else {
            this.indexationMap.put(id, fields);
        }
    }

    public boolean preInit(TopiaContextImplementor context) {
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        this.context = context;
        Properties prop = context.getConfig();
        String dirname = prop.getProperty("topia.index.lucene.directory");
        this.directory = new File(dirname);
        this.directory.mkdirs();
        return true;
    }

    @Override
    public void clearLastRecordedIndexation() {
        this.indexationMap.clear();
    }

    @Override
    public void doIndexation() {
        block9: {
            try {
                String id;
                boolean create = false;
                if (!IndexReader.indexExists((File)this.directory)) {
                    create = true;
                } else {
                    IndexReader reader = IndexReader.open((File)this.directory);
                    for (Map.Entry<Object, Object[]> e : this.indexationMap.entrySet()) {
                        id = e.getKey().toString();
                        this.removeIndex(reader, id);
                    }
                    reader.close();
                }
                IndexWriter writer = new IndexWriter(this.directory, (Analyzer)new SimpleAnalyzer(), create);
                for (Map.Entry<Object, Object[]> e : this.indexationMap.entrySet()) {
                    id = e.getKey().toString();
                    Object[] fields = e.getValue();
                    if (fields == null) continue;
                    try {
                        this.index(writer, id, fields);
                    }
                    catch (HibernateException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't index: " + id));
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"StackTrace", (Throwable)eee);
                    }
                    catch (TopiaNotFoundException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't index: " + id));
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"StackTrace", (Throwable)eee);
                    }
                }
                writer.close();
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block9;
                log.warn((Object)"Can't index");
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
    }

    private void index(IndexWriter writer, String id, Object[] fields) throws IOException, HibernateException, TopiaNotFoundException {
        String classname = TopiaId.getClassNameAsString((String)id);
        ClassMetadata cm = this.context.getHibernateFactory().getClassMetadata(classname + "Impl");
        String[] names = cm.getPropertyNames();
        Document doc = new Document();
        doc.add((Fieldable)new Field("class", classname, Field.Store.YES, Field.Index.TOKENIZED));
        doc.add((Fieldable)new Field(TOPIA_ID, id, Field.Store.YES, Field.Index.TOKENIZED));
        StringBuffer all = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            String name = names[i];
            Object o = fields[i];
            if (o == null) continue;
            String val = String.valueOf(o);
            doc.add((Fieldable)new Field(name, val, Field.Store.YES, Field.Index.TOKENIZED));
            all.append(val);
            all.append(" ");
        }
        if (all.length() > 0) {
            doc.add((Fieldable)new Field("__all__", all.toString(), Field.Store.NO, Field.Index.TOKENIZED));
        }
        writer.addDocument(doc);
    }

    private void removeIndex(IndexReader reader, String id) throws IOException {
        Term term = new Term(TOPIA_ID, id);
        reader.deleteDocuments(term);
    }

    @Override
    public SortedSet<IndexEntry> search(String queryText) {
        Hits hits;
        block13: {
            hits = null;
            if (IndexReader.indexExists((File)this.directory)) {
                try {
                    IndexSearcher searcher = new IndexSearcher(this.directory.getAbsolutePath());
                    SimpleAnalyzer analyzer = new SimpleAnalyzer();
                    if (queryText.equals("") || queryText.length() == 0) {
                        log.debug((Object)"requete vide, pas de resultat a renvoyer.");
                        break block13;
                    }
                    QueryParser parser = new QueryParser("__all__", (Analyzer)analyzer);
                    Query luceneQuery = parser.parse(queryText);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Recherche du terme : " + luceneQuery.toString()));
                    }
                    hits = searcher.search(luceneQuery);
                    searcher.close();
                }
                catch (IOException ioe) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)ioe.getMessage(), (Throwable)ioe);
                    }
                    break block13;
                }
                catch (ParseException pe) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)pe.getMessage(), (Throwable)pe);
                    }
                    break block13;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Index inexistant, pas de resultats \u00e0 renvoyer !");
            }
        }
        TreeSet<IndexEntry> result = new TreeSet<IndexEntry>();
        if (hits != null) {
            for (int i = 0; i < hits.length(); ++i) {
                try {
                    float score = hits.score(i);
                    Document doc = hits.doc(i);
                    String topiaId = doc.get(TOPIA_ID);
                    IndexEntry ie = new IndexEntry(score, topiaId);
                    result.add(ie);
                    continue;
                }
                catch (IOException eee) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Can't get result");
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"StackTrace is", (Throwable)eee);
                }
            }
        }
        return result;
    }

    @Override
    public SortedSet<IndexEntry> search(Map query) {
        SortedSet<IndexEntry> result = null;
        String queryText = "";
        for (String key : query.keySet()) {
            String value = (String)query.get(key);
            if (value == null) continue;
            String[] st = value.split("\\s");
            for (int i = 0; i < st.length; ++i) {
                String token = st[i];
                if (token == null || token.equals("")) continue;
                queryText = queryText + key + ":" + st[i] + " ";
            }
        }
        result = this.search(queryText);
        return result;
    }
}

