package org.nuiton.topia.flyway;

/*
 * #%L
 * ToPIA :: Flyway integration service
 * $Id: TopiaFlywayService.java 3147 2014-06-03 19:45:39Z bleny $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-6/topia-service-flyway/src/main/java/org/nuiton/topia/flyway/TopiaFlywayService.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaMigrationService;

/**
 * Integrates Topia with <a href="http://flywaydb.org/">Flyway database migration framework</a>.
 *
 * @since 3.0
 */
public interface TopiaFlywayService extends TopiaMigrationService {

    /**
     * If you want flyway to init with an already existing DB, you must use
     * this configuration and give, as value the version of the already
     * existing schema.
     */
    public static final String FLYWAY_INIT_VERSION = "flyway.initVersion";

}
