/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

public class EntityInterfaceTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityInterfaceTransformer.class);
    private static final String doubleQuote = "\"";
    private static final String comma = ",";

    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String clazzName = clazz.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity : " + clazz.getQualifiedName()));
        }
        ObjectModelInterface result = this.createInterface(clazzName, clazz.getPackageName());
        this.addImport((ObjectModelClassifier)result, SearchFields.class);
        this.addImport((ObjectModelClassifier)result, TopiaEntity.class);
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)clazz)) {
            this.setDocumentation((ObjectModelElement)result, clazz.getDocumentation());
        }
        this.generateSearchFields(result, clazz);
        for (ObjectModelInterface parent : clazz.getInterfaces()) {
            this.addInterface((ObjectModelClassifier)result, parent.getQualifiedName());
        }
        for (ObjectModelInterface parent : clazz.getSuperclasses()) {
            if (!parent.hasStereotype("entity")) continue;
            this.addInterface((ObjectModelClassifier)result, parent.getQualifiedName());
            break;
        }
        this.addInterface((ObjectModelClassifier)result, TopiaEntity.class);
        this.generateStaticColumnNames(result, clazz);
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model)) continue;
            if (attr.hasAssociationClass()) {
                this.addAssociationAttribute(result, attr);
                continue;
            }
            this.addNoneAssociationAttribute(result, attr);
        }
        this.generateAssociationAttributes(result, clazz);
        this.generateInterfaceOperations(result, (ObjectModelClassifier)clazz);
    }

    protected void generateAssociationAttributes(ObjectModelInterface result, ObjectModelClass clazz) {
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String type = attr.getType();
                String name = attr.getName();
                this.generateAssociationAccessors(result, name, type);
                if (attr.getReverseAttribute() != null) continue;
                type = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
                name = attr.getDeclaringElement().getName();
                this.generateAssociationAccessors(result, name, type);
            }
        }
    }

    protected void addNoneAssociationAttribute(ObjectModelInterface result, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            ObjectModelParameter attr2 = this.addParameter(op, attrType, GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "La valeur de l'attribut " + attrName + " \u00e0 positionner.");
            op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName), attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
        } else {
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "add" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            ObjectModelParameter attr2 = this.addParameter(op, attrType, GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "L'instance de " + attrName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)result, "addAll" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            attr2 = this.addParameter(op, collectionInterface + "<" + attrType + ">", GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "Les instances de " + attrName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            attr2 = this.addParameter(op, collectionInterface + "<" + attrType + ">", GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "La Collection de " + attrName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)result, "remove" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            attr2 = this.addParameter(op, attrType, GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "L'instance de " + attrName + " \u00e0 retirer");
            op = this.addOperation((ObjectModelClassifier)result, "clear" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            this.setDocumentation((ObjectModelElement)attr2, "Vide la Collection de " + attrName);
            op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName), collectionInterface + "<" + attrType + ">", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, "Retourne la collection.");
            }
            if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName) + "ByTopiaId", attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
                this.setDocumentation((ObjectModelElement)op, "Recup\u00e8re l'attribut " + attrName + " \u00e0 partir de son topiaId");
                attr2 = this.addParameter(op, String.class, "topiaId");
                this.setDocumentation((ObjectModelElement)attr2, "le topia id de l'entit\u00e9 recherch\u00e9e");
            }
            op = this.addOperation((ObjectModelClassifier)result, "size" + StringUtils.capitalize((String)attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            this.setDocumentation((ObjectModelElement)op, "Retourne le nombre d'\u00e9l\u00e9ments de la collection " + attrName);
            op = this.addOperation((ObjectModelClassifier)result, "is" + StringUtils.capitalize((String)attrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            this.setDocumentation((ObjectModelElement)op, "Retourne {@code true} si la collection " + attrName + " est vide.");
        }
    }

    protected void addAssociationAttribute(ObjectModelInterface result, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
        String assocClassFQN = attr.getAssociationClass().getQualifiedName();
        String assocClassName = attr.getAssociationClass().getName();
        if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            ObjectModelParameter attr2 = this.addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "La valeur de l'attribut " + assocClassName + " \u00e0 positionner");
            this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        } else {
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "add" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            ObjectModelParameter attr2 = this.addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "L'instance de " + assocClassName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)result, "addAll" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            attr2 = this.addParameter(op, collectionInterface + "<" + assocClassFQN + ">", GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "Les instances de " + assocClassName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            attr2 = this.addParameter(op, collectionInterface + "<" + assocClassFQN + ">", GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "La Collection de " + assocClassName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)result, "remove" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            attr2 = this.addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "L'instance de " + assocClassName + " \u00e0 retirer");
            op = this.addOperation((ObjectModelClassifier)result, "clear" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            this.setDocumentation((ObjectModelElement)op, "Vide la Collection de " + assocClassName + " .");
            this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), collectionInterface + "<" + assocClassFQN + ">", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName) + "ByTopiaId", assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
                this.setDocumentation((ObjectModelElement)op, "Recup\u00e8re l'attribut " + attrName + " \u00e0 partir de son topiaId");
                attr2 = this.addParameter(op, String.class, "topiaId");
                this.setDocumentation((ObjectModelElement)attr2, "le topia id de l'entit\u00e9 recherch\u00e9e");
            }
            op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN, new ObjectModelModifier[0]);
            this.addParameter(op, attrType, "value");
            this.addOperation((ObjectModelClassifier)result, "size" + StringUtils.capitalize((String)assocAttrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            this.addOperation((ObjectModelClassifier)result, "is" + StringUtils.capitalize((String)assocAttrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        }
    }

    private void generateInterfaceOperations(ObjectModelInterface output, ObjectModelClassifier classifier) {
        for (ObjectModelOperation op : classifier.getOperations()) {
            String visibility = op.getVisibility();
            if (op.hasStereotype("dao") || !visibility.equals(ObjectModelModifier.PUBLIC.toString())) continue;
            String opName = op.getName();
            String opType = op.getReturnType();
            ObjectModelOperation op2 = this.addOperation((ObjectModelClassifier)output, opName, opType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                this.setDocumentation((ObjectModelElement)op2, op.getDocumentation());
            }
            for (ObjectModelParameter param : op.getParameters()) {
                String paramName = param.getName();
                String paramType = param.getType();
                ObjectModelParameter param2 = this.addParameter(op2, paramType, paramName);
                if (!TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)param)) continue;
                this.setDocumentation((ObjectModelElement)param2, param.getDocumentation());
            }
            for (String exception : op.getExceptions()) {
                this.addException(op2, exception);
            }
        }
    }

    private void generateAssociationAccessors(ObjectModelInterface output, String attrName, String attrType) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(op, attrType, "value");
        this.setDocumentation((ObjectModelElement)param, "La valeur de l'attribut " + attrName + " \u00e0 positionner.");
        op = this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)attrName), attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        this.setDocumentation((ObjectModelElement)op, "Retourne la valeur de l'attribut " + attrName + ".");
    }

    private String getStringRepresentation(List<String> strings) {
        StringBuilder result = new StringBuilder();
        Iterator<String> it = strings.iterator();
        if (it.hasNext()) {
            result.append(doubleQuote).append(it.next()).append(doubleQuote);
        }
        while (it.hasNext()) {
            result.append(comma).append(doubleQuote).append(it.next()).append(doubleQuote);
        }
        return result.toString();
    }

    private void generateSearchFields(ObjectModelInterface result, ObjectModelClass clazz) {
        ArrayList<String> txtFields = new ArrayList<String>();
        ArrayList<String> numFields = new ArrayList<String>();
        ArrayList<String> boolFields = new ArrayList<String>();
        ArrayList<String> dateFields = new ArrayList<String>();
        ArrayList allAttrs = new ArrayList();
        allAttrs.addAll(clazz.getAttributes());
        allAttrs.addAll(clazz.getAllOtherAttributes());
        boolean needAnnotation = false;
        for (ObjectModelAttribute attr : allAttrs) {
            String name = GeneratorUtil.toLowerCaseFirstLetter((String)attr.getName());
            if (TopiaGeneratorUtil.isTextType(attr)) {
                txtFields.add(name);
                needAnnotation = true;
                continue;
            }
            if (TopiaGeneratorUtil.isNumericType(attr)) {
                numFields.add(name);
                needAnnotation = true;
                continue;
            }
            if (TopiaGeneratorUtil.isBooleanType(attr)) {
                boolFields.add(name);
                needAnnotation = true;
                continue;
            }
            if (!TopiaGeneratorUtil.isDateType(attr)) continue;
            dateFields.add(name);
            needAnnotation = true;
        }
        StringBuilder annotationCode = new StringBuilder();
        annotationCode.append("SearchFields (");
        if (needAnnotation) {
            StringBuilder buffer = new StringBuilder();
            if (!txtFields.isEmpty()) {
                buffer.append("\n  txtFields={");
                buffer.append(this.getStringRepresentation(txtFields));
                buffer.append("}");
                if (!(numFields.isEmpty() && boolFields.isEmpty() && dateFields.isEmpty())) {
                    buffer.append(comma);
                }
            }
            if (!numFields.isEmpty()) {
                buffer.append("\n  numFields={");
                buffer.append(this.getStringRepresentation(numFields));
                buffer.append("}");
                if (!boolFields.isEmpty() || !dateFields.isEmpty()) {
                    buffer.append(comma);
                }
            }
            if (!boolFields.isEmpty()) {
                buffer.append("\n  boolFields={");
                buffer.append(this.getStringRepresentation(boolFields));
                buffer.append("}");
                if (!dateFields.isEmpty()) {
                    buffer.append(comma);
                }
            }
            if (!dateFields.isEmpty()) {
                buffer.append("\n  dateFields={");
                buffer.append(this.getStringRepresentation(dateFields));
                buffer.append("}");
            }
            annotationCode.append("" + buffer.toString() + "\n" + "");
        }
        annotationCode.append(")");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)result, annotationCode.toString());
    }

    private void generateStaticColumnNames(ObjectModelInterface result, ObjectModelClass clazz) {
        String attrColName;
        String attrName;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (!attr.hasAssociationClass()) {
                attrName = attr.getName();
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            }
            attrColName = this.getConstantName(attrName);
            this.addAttribute((ObjectModelClassifier)result, attrColName, String.class, doubleQuote + attrName + doubleQuote, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                attrName = attr.getName();
                attrColName = this.getConstantName(attrName);
                this.addAttribute((ObjectModelClassifier)result, attrColName, String.class, doubleQuote + attrName + doubleQuote, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            }
        }
    }
}

