package org.nuiton.topiatest.deletetest;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;


public abstract class Telephone2DAOAbstract<E extends Telephone2> extends Contact2DAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Telephone2.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByPrefix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut prefix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPrefix(String v) throws TopiaException {
        E result = findByProperty("prefix", v);
        return result;
    }

    /**
     * findAllByPrefix :
     * Retourne les éléments ayant comme valeur pour l'attribut prefix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPrefix(String v) throws TopiaException {
        List<E> result = findAllByProperty("prefix", v);
        return result;
    }

    /**
     * findByCountry :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut country le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCountry(String v) throws TopiaException {
        E result = findByProperty("country", v);
        return result;
    }

    /**
     * findAllByCountry :
     * Retourne les éléments ayant comme valeur pour l'attribut country le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCountry(String v) throws TopiaException {
        List<E> result = findAllByProperty("country", v);
        return result;
    }


} //Telephone2DAOAbstract<E extends Telephone2>
